#import "@preview/hydra:0.6.2": hydra, anchor

#let full = true
#let options = json("book-of-ceremonies-options.json")
#let sections = options.sections
#for (section, value) in sections {
	if (value == false) {
		full = false
	}
}
#let excerpts = (full == false)

/**
 * The document was composed in June, 2022. We could embed that
 * date into the PDF, by setting datetime(year: 2022, month: 06,
 * day: 01), but since this PDF should offer a lot of options,
 * that feels wrong. Or we could leave it at the default (auto),
 * which would always embed the current date, which also feels
 * wrong. So instead, we'll explicitly set it to none, which
 * prevents any date being embedded.
 */
#set document(
	title: [#{if excerpts {[An Excerpt from the]}} Kingdom of Drachenwald Book of Ceremonies: Fourth Edition],
	date: none,
)

#{
	if (options.cover) {
		set align(center)
		set heading(outlined: false)
		show heading: it => block(
			width: 100%,
			inset: 8pt,
			radius: 8pt,
			fill: rgb("ff0000"),
			text(20pt, fill: rgb("f4ff00"), it)
		)
		heading(level: 1)[
			#{if excerpts {[An Excerpt from the\ ]}}
			Kingdom of Drachenwald\
			Book of Ceremonies
		]
		set align(horizon)
		image("drachenwald-crest.svg")
		set align(bottom)
		heading(level: 2)[Fourth Edition\ June 2022]
		pagebreak()
	}
}

#let bigheading(it) = {
	set text(font: "Liberation Sans")
	block(
		width: 100%,
		inset: 8pt,
		stroke: (bottom: 1pt),
		it
	)
}

#show heading.where(level: 1): it => bigheading(it)
#show heading.where(level: 2): it => bigheading(it)
#show heading.where(level: 3): it => strong(emph(it))

#let name = [\_\_\_\_\_\_\_\_\_\_\_\_]
#let response = name + name

#set text(size: options.size * 1pt)
#if options.outline {
	// If there's no cover page, we'll put the title here.
	// We'll put it as plain text, not a header.
	let title = [Table of Contents]
	if (options.cover == false) {
		title = [Kingdom of Drachenwald Book of Ceremonies] + {
			if excerpts {[ (Excerpt)]}
		}
	}
	outline(title: title, depth: 2)
	pagebreak()
	// If they turn off both the cover page and the table of contents,
	// we'll not output a title. They really don't want it at that stage.
}

#counter(page).update(1)
#set page(
	// The anchor in the heading allows hydra to determine
	// which headings appear on this page, so it can display
	// them in the footer.
	header: anchor(),
	footer: context {
	set text(10pt)
	grid(
		columns: (80%, 20%),
		align: (left, right),
		hydra(2),
		counter(page).display("1 of 1", both: true)
	)
})

#set par(justify: options.justify, first-line-indent: 0.8em, spacing: 1em)

#if sections.i [
= Part I Introduction
<part-i-introduction>
The Drachenwald Book of Ceremonies was originally compiled by Mistress
Adelaide de Beaumont, then Schwarzdrachen Herald, as a part of the
project of Drachenwald becoming a Kingdom. Ten years later, Marcus and
Anna, then Crown Prince and Princess, commissioned a revision of the
ceremony and oaths for their coronation, and this led to an updated
Second Edition of the entire book. A third edition was produced when the
Order of Defence became a fourth order of bestowed peerage.

This fourth edition has been created for a couple of reasons. The first
is to include the new grant level awards of the Orders of the Ring. The
second is to take into account that a ruling couple may no longer be one
man and one woman, but two of the same or that they or a
recipient/candidate may not consider themselves as either.

While new editions of the Book of Ceremonies have only been published
once a decade, one should keep in mind that a book like this is by its
nature a work in progress: new ceremonies appear and old ones are
changed as needed. However, most changes that happen over the years are
minor, and this is as it should be. Ceremonies are one of the
fundamental aspects of this Society, and while it is possible to change
them, this should be done slowly and with reverence.

Nevertheless, while the standard ceremonies change relatively little
over time, there is room for alternate ceremonies and oaths. There is a
companion volume to this Book that includes such additional material;
more would be welcome.

In terms of practical heralding, it is also permitted to drop parts of
ceremonies where this may prove advantageous. When you are aware that a
court will be long, you will do yourself and the Crown more favour by
being as succinct as possible rather than reading the introduction to
each and every order or award being presented.

#par(first-line-indent: 0em)[
In service,\
Nicholas de Estleche dictus le Tardif, Schwarzdrachen]

== Definitions
<definitions>
/ Crowns: The ruling couple of Drachenwald
/ Sovereign: The Crown by right of arms
/ Consort: The Crown by inspiration
/ Monarch: Either of the Crowns, when interchangeable
/ Coronet: The ruling couple of a Principality

These are designations of convenience only, and the actual titles
preferred by the individuals concerned should be used.

== Version History
<version-history>
- First edition: 1993, ed. by Adelaide de Beaumont
- Second edition: 2004, ed. by Pietari Uv
- Third edition: 2017, ed. by Pietari Uv
- Fourth edition: 2021, ed. by Nicholas de Estleche
]

#show heading.where(level: 1): it => {
	if options.pagebreak-first {
		pagebreak(weak: true)
	}
	it
}
#show heading.where(level: 2): it => {
	if options.pagebreak-second {
		pagebreak(weak: true)
	}
	it
}

#if sections.ii [
= Part II Advice for their Majesties
<part-ii-advice-for-their-majesties>
- The court is where you truly become the embodiment of Drachenwald.
  Here is where you project the Kingdom as you wish it to be, where you
  make the Kingdom as you wish it to be. The words you speak here become
  the reality of Drachenwald, whether that be the Law, the raising of
  those deserving reward or the declaration of war and peace. Your
  decisions will be made elsewhere, but here is where they become
  substance. This will be someone’s first experience of Drachenwald
  ceremony, it will be their first recognition for their service or
  skills and it will be where they are celebrated for their
  accomplishments.
- Your herald is not just your messenger. When they wear your tabard,
  they don’t just speak for you, they speak #strong[as] you. They are
  how you project your voice and command before recording devices. Your
  herald is inviolable, as are the heralds of others. As your herald is
  treated by others, so are you, and vice versa.
- Unless you have been a herald previously, there will be much
  unfamiliar about the process and running of courts. Your herald can
  guide you.
- When speaking with the intent to be heard by more than just an
  individual, speak louder and slower than you would normally. One of
  the most frustrating things as an attendee of court is being unable to
  hear the business being enacted. Your herald speaks as you, so can
  take the load, or conversely you may wish to speak in person more than
  is the guide in this book.
- Know the space in which you will be presiding. This applies to such
  things as obstacles, compactness, acoustics, light levels, etc.
- Be aware of the state of those being called before you you. For some,
  even a joyful reward can be a stressful experience when singled out in
  public. There is no requirement that an award be a surprise. Some
  people enjoy that, some would prefer to be prepared. A summons to
  court, in as much detail as you think warranted, can be a good option
  for the latter.
- A specific case of the previous point are newcomers. They will be at
  their first event, know very few people, most likely still be
  uncomfortable in their clothes and completely unfamiliar with what to
  do in court. Surprise is just extra stress and they should be called
  up after they have had a chance to see how more experienced members
  approach.
- Courts can be as formal or informal as you desire, and can have
  different priorities. For example, it may be that rewarding a fighter
  at the castle gates prior to the assault may be more meaningful than
  in a formal court. The trade off is that fewer people will be witness.
- Try to avoid long courts: they are not popular, if sometimes
  necessary. If a court must be long consider building in a break or
  give permission for people to come and go. Much of the formality of
  awards and orders will be generally well known, and can be dispensed
  with when time is at a premium.
- Prepare as much of the court business as far ahead of the event as
  possible. Know who your herald will be and involve them. It is
  inevitable that you will not have anywhere near as much spare time at
  an event as you think. You will have meetings, consultations,
  tournaments, displays and waylayers. Time to prepare an entire court
  on the day will be very restricted.
]

#if sections.iii [
= Part III Advice for Heralds
<part-iii-advice-for-heralds>
- When you wear their Majesties’ tabard, you do more than just represent
  them, you speak #strong[as] them. What you do reflects directly upon
  them. You should act as they would. Remember however, that when their
  Majesties ask you to do something in their name, you are their voice.
  It can sometimes be daunting to ask, or even instruct, those who would
  normally be of higher rank and experience within the Society than you.
  As their Majesties herald, though, you act with their authority.
- Advise their Majesties honestly, on tradition, on what is period, on
  how best to accomplish something. In the end though, the final
  decision is theirs.
- Know the space in which you will be presiding. This applies to such
  things as obstacles, compactness, acoustics, light levels, etc.
- You do not have to do everything within court yourself. Delegate to
  others. Small jobs, such as the reading of a scroll, can be good
  starting points for those wishing to gain experience in the business
  of court heraldry.
- Make sure the court has the physical items necessary. Tables, not just
  for royalty, but for business items and your drink. Chairs not just
  for their Majesties, but also for any with business in court who are
  infirm. A chair is also often appreciated by those receiving a peerage
  as it is a long ceremony and one they should enjoy rather than getting
  sore knees.
- Receiving an award is often an emotional experience. Give the
  recipient time to take it in.
- As far as possible make sure newcomers know that they will be called
  up and know what to do. Ideally they should be called after they’ve
  had a chance to observe more experienced members. They will be unsure
  and unfamiliar, amongst people they don’t know.
- Always place a drink for yourself in the court before it starts.
- #strong[Vivat] is for one person, #strong[vivant] for more than one.
]

#if sections.iv [
= Part IV Business Checklist
<part-iv-business-checklist>
This is not a mandatory list, but considering each item for inclusion
will help ensure all potential business has been considered. Different
items can be intertwined.

- Awards and Orders (usually ordered with lowest precedence first, but
  be flexible). A peerage is usually the last piece of business of a
  court, whether that be invocation or elevation.
- Children.
- Those for whom it is their first court \[in Drachenwald\] (near the
  end of court).
- The business of other royalty present.
- Guild business.
- Tournaments and competition proclamations and results.
- Event Steward & staff.
- Head Cook & staff.
- Oaths of Fealty (peerages, officers, personal).
- Inductions into positions of fealty or office.
- Interludes (music, poetry, stories, etc.). Not a good idea in already
  long courts.
- Ambassadors
- Anyone who has requested time for other business.
]

#if sections.v [
= Part V Physical Layout
<part-v-physical-layout>
Not all courts have to involved the Sovereigns in being seated. These
can be far more fluid in conduct and set up. for a more formal court:
- Placing the entire retinue behind the thrones is to be discouraged.
- The herald should be in position to move freely: to centre stage as
  voice, into the background, to interact with the Sovereigns and to
  guide those called into the royal presence.
- Guards and champions should be where they can physically do their job.
- Attendants need easy access to provide drinks, refills, snacks and
  paraphenalia to the Sovereigns.
- An ideal court would have a chronicler, although this has been rarely
  done. If you know something complicated or freestyle may occur, a
  chronicler is recommended. They will need a table and chair.
- The Sovereigns will need a table for their drinks and stuff. A table
  will be needed for tokens and other objects to be held until they are
  needed. The herald should have a table for a drink and other items
  required for court.
- There should be corridors to allow the nobles access to their
  Sovereigns as commanded. If the Sovereigns intend to process in ot
  out, make sure that corridor is large enough for the retinue.
- You will need enough space for those called forwards. If this is
  likely to be a large number, such as prior to a vigil or for an
  elevation, take this into account.
- A stool and/or cushon should be provided for kneeling in front of the
  Sovereigns. Keep a spare chair handy for any who may be unable to
  kneel. A chair is also handy for elevation ceremonies for the
  candidate, however fit.
- Other royalty invited to attend in state should be arranged from the
  Sovereigns, those cloest being higher in precedence. Remember that
  those who rule the lands for their Majesties, such as Princes or
  Barons, jump up the order in their own lands.
- Ideally the peerage should be sat closest to the Sovereigns, either in
  the front rows or in choirs to the side. Peers are as easy to herd as
  cats, so this will rarely be achieved to perfection.

#{
	if options.layoutimage {
		image("layout.png")
	}
}
]

#if sections.iv [
= Part VI Royalty
<part-vi-royalty>
For distinction, the Crown who is monarch by right of arms is called
Sovereign, their inspiration is called Consort.
]

#if sections.vi1 [
== 1. Invocation to the Crown Lists
<invocation-to-the-crown-lists>
/ Herald: #block[
Their Royal Majesties command the presence of all entrants in the Crown
Lists, that they should present themselves and their consorts before the
Crown.
]

#emph[Couples approach the thrones one at a time, exchange a few words
with the Crown, receive usually some token of the day, withdraw slightly
and kneel.]

/ Herald: #block[
My Lords and Ladies, you know well that true gentles enter combat not
for their own personal glory, but rather to advance the honour of their
consorts; and to prove, by their courtesy and valour upon the field,
their worthiness of that honour.

Be mindful, as you fight, of your consort’s honour as well as your own,
for your consort personifies all honour and loyalty, beauty and truth –
they embody the love that is worthy of great reward.

Therefore, today you fight in the Crown Lists not to gain power for
yourself, not for your own glory and honour, as you may in other lists.
You fight instead for the honour and glory of the one whose favour you
bear upon the field, whom you would advance by your valour, skill and
courtesy.

And should victory be granted to you this day, you will be crowned
together as the Heirs of Drachenwald, until the day of your coronation
shall come.
]

/ Sovereign: #block[
You have heard the reasons for our lists. Each of you here today has an
inspiration whose favour you would advance, whom you would crown this
day as your consort. Is it still your desire to participate in these
lists?
]

/ Entrants: #block[
It is.
]

/ Consort: #block[
Do each of you, entrant and consort, now affirm that you, fulfil all the
qualifications for fighting today as set forth by our laws?
]

/ Entrants and Consorts: #block[
I do.
]

/ Sovereign: #block[
And do you all here know the Rules of the Lists and swear to abide them?
]

/ Entrants: #block[
I do.
]

/ Consort: #block[
Then bear your favours bravely into battle, and prove the worth and
virtue of your consorts, whether in victory or in honourable defeat. You
have our leave to withdraw and prepare.
]
]

#if sections.vi2 [
== 2. Investiture of the Heirs
<investiture-of-the-heirs>
/ Herald: #block[
#name, given victory this day upon the field of
honour, Their Majesties command you to present yourself and your Consort
#name before the thrones.
]

#emph[Victor and Inspiration come forward, bow and kneel. The Crowns
rise. Courtiers with the Coronets come forward from the Royal entourage,
bow before the Crowns and kneel beside Victor and Inspiration. The
Crowns take the Coronets from the cushions. Courtiers remain kneeling.]

/ Sovereign: #block[
#name, by your valour and skill, you have most nobly
advanced the honour of your Inspiration and won yourself a high estate.
I do hereby acknowledge your right to succeed to these our lands.
]

/ Consort: #block[
And you, #name, by your grace and virtue you have
inspired your champion to victory. I do hereby acknowledge your right to
succeed to these our lands.
]

#emph[The Crowns hold the Coronets high above the heads of the victor
and the inspiration and crown them, while they speak the following
words.]

/ Sovereign & Consort: #block[
Be thou Crown Prince / Princess of Drachenwald.
]

#emph[The Crowns raise the Heirs, whilst the herald speaks the following
words.]

/ Herald: #block[
For the new Heirs to Drachenwald. Vivant! Vivant! Vivant!
]

#emph[The Crowns and Heirs sit in their thrones and the Royal court
continues with regular business.]
]

#if sections.vi3 [
== 3. Coronation
<coronation>
=== Opening

/ Herald: #block[
All rise!
All rise for their \<adjective\> Majesties #name and
#name, Noble and wise rulers of the Kingdom of
Drachenwald, from Aarnimetsä to Adamestor, undoubted and sole Sovereigns
of all lands to the East of the Atlantic Sea!
]

#emph[The Crowns process in and are seated. They give those in
attendance leave to sit.]

/ Herald: #block[
Your Majesties, do you have any words for these, your people?
]

#emph[The Crowns make personal statements from their thrones.]

=== Call Forward the Heirs

/ Sovereign: #block[
Herald, call forward our successor.
]

/ Herald: #block[
Their Majesties call before them Crown Prince\[ss\]
#name, heir to the throne of Drachenwald.
]

/ Heirs’ Herald: #block[
Make way, make way for their Royal Highness #name,
Crown Prince\[ss\] of Drachenwald!
]

#emph[The Victor comes forward, makes reverence, but remains standing.
Any escort retires save his Champion, if present.]

/ Victor: #block[
Your Majesty, you accepted me as your successor on the day of my victory
in the Crown lists. I come before you now to claim the Crown and Throne
of Drachenwald, as is my right.
]

/ Sovereign: #block[
Indeed they shall be yours, for you are my true and undoubted heir.

Know you all, that anyone challenging this right must first best me.
Does any so challenge?
]

#emph[Short pause.]

/ Consort: #block[
Your Highness, great are the burdens of the Crown; you cannot bear them
alone. Who will share this burden and rule beside you?
]

/ Victor: #block[
They who inspired me to victory, #name.
]

/ Consort: #block[
#emph[signals herald]
]

/ Herald: #block[
Their Majesties call before them Crown Prince\[ss\]
#name, heir to Drachenwald.
]

/ Heirs’ Herald: #block[
Make way, make way for their Royal Highness #name,
Crown Prince\[ss\] of Drachenwald!
]

#emph[The Inspiration comes forward and makes reverence. It is best they stand
at an oblique angle to the Crowns so that their words may be heard by
all.]

#emph[Any escort retires.]

/ Sovereign / Herald: #block[
Heirs to the throne of Drachenwald, listen well.

The Crown is a weighty burden. As Monarchs you will stand highest in the
sight of your people, but you must nonetheless take upon yourselves the
heaviest burdens and the gravest responsibilities.
]

/ Consort / Herald: #block[
You must at all times place the good of the Kingdom before your own
interests. You must be a source of strength and wisdom for Your people.
]

/ Sovereign / Herald: #block[
You must be foremost in valour upon the field of battle and gentlest in
courtesy. You must foster the pursuits of peace and beauty as well as
the arts of war. You must see that the scales of justice balance fairly
for high and low alike.
]

/ Consort / Herald: #block[
You must take counsel, make just laws and you must lead your people to
prosperity.
]

/ Sovereign / Herald: #block[
Knowing these things, do you still wish to take the Crowns of
Drachenwald?
]

/ Victor & Inspiration: #block[
I do.
]

=== Coronation Oath

/ Sovereign / Herald: #block[
Let the Seneschal come forward and administer the coronation oath.
]

#emph[The Kingdom Seneschal comes forward, bows and stands beside the
Consort’s throne. The Heirs keep standing and put their right hand on
the Book (ideally, a nicely bound book of the Corpora and/or Kingdom
law) or on a sword.]

/ Seneschal: #block[
Do you swear to love all that is true and fair, and fight all
falsehoods, lies and injustice, both with your Royal power and with
justice?
]

/ Victor & Inspiration: #block[
I do.
]

/ Seneschal: #block[
Will you be true to your people, confirm to them their old rights and
privileges, and not remove from anyone what is rightfully theirs, except
after proper verdict of law?
]

/ Victor & Inspiration: #block[
I so swear.
]

/ Seneschal: #block[
Will you protect the Realm to the best of your ability, so that when the
time comes you will leave your successors a strong Kingdom, as is their
due?
]

/ Victor & Inspiration: #block[
I so swear.
]

#emph[The Seneschal retires.]

=== The Coronation

#emph[The Heirs kneel on the cushions before the outgoing Crowns, who
stand up.]

#emph[If the Heirs are to be anointed, they are anointed here with such
chrism as they think best. Likewise it is here that they may take up
such sceptre, orb and swords of justice and mercy as they please or as
tradition demands.]

#emph[Two nobles come forward with cushions and kneel beside the Heirs.
The Crowns remove the Heirs’ coronets and place them on the cushions,
the courtiers bow and retire from the Presence.]

#emph[The following should be done as simultaneously as possible:]

#emph[The Crowns remove their Crowns and hold them above the heads of
the Heirs.]

/ Sovereign: #block[
#response
]

/ Consort: #block[
#response
]

/ Sovereign & Consort (together): #block[
Be thou \[King / Queen / preferred title\].
]

#emph[With this last sentence, the old Crowns crown the new Crowns. They
raise them, so that they stand beside them.]

/ Heirs’ Herald, hereafter the Herald: #block[
For their Majesties #name and
#name, Vivant, vivant, vivant!
]

#emph[The former Crowns step back in front of the new Crowns and bow.]

/ Former Sovereign: #block[
Your Majesties, let us be the first to congratulate you both and wish
you all success and a bountiful reign.
]

/ Sovereign: #block[
We thank you. You are released by our word from the burden of the Crown
which we now bear in your stead. Go now with our blessings and the
thanks of Drachenwald.
]

/ Herald: #block[
For #name and #name, Vivant,
vivant, vivant!
]

#emph[Outgoing Crowns bow and retire with their retinue, led by their
heralds.]

=== Oaths of Office

/ Herald: #block[
Let those Officers of State who are ready to swear their oaths of office
come forward.
]

#emph[The officers of state come forward and kneel.]

/ Herald: #block[
Do you swear on your honour to hold #name and
#name your rightful Sovereigns, until the end of
their lawful reign, and support their royal might and justice?
]

/ Officers: #block[
I do.
]

/ Herald: #block[
Will you give them such obedience as is their due, obeying their
commands in such matters as are theirs to command?
]

/ Officers: #block[
I will.
]

/ Herald: #block[
Will you be true officers of the Kingdom, discharging your duties to the
best of your ability?
]

/ Officers: #block[
I will.
]

/ Sovereign: #block[
And We in turn promise to support You with our royal power and justice.
So say We #name, Rex/Regina.
]

/ Consort: #block[
So say We #name, Rex/Regina.
]

#emph[The officers retire.]

=== Fealty of Peers

#emph[The peers can be called forward all at once, by order, or singly.
If there are many it is better to call them by their orders since
otherwise they swear in a great mob. If they are called at once, it is
done like this:]

/ Herald: #block[
Let all Peers of Our realm who wish to swear fealty at this time come
forward.
]

#emph[If each group of peers are called separately they are called as
follows:]

/ Herald: #block[
Let all Royal Peers who wish to swear fealty at this time come forward.
Stand forth those of the Most Ancient Order of the Chivalry who are
ready to swear fealty.

Let all members of the Order of the Chivalry who wish to swear fealty at
this time come forward.

Stand forth those of the Right Worshipful Order of the Laurel who are
ready to swear fealty.

Stand forth those of the Right Noble Order of the Pelican who are ready
to swear fealty.

Stand forth those of the Right Trusty Order of the Defence who are ready
to swear fealty.
]

#emph[Peers come forward, bareheaded and ungirt, and bow and kneel as to
do homage. If possible they swear their oath on a book or on a sword or
other relic. If there are many, the book, sword or other relic should be
brought forward so that they may be on many sides of it. It is not meet
to force them to assemble touching each other’s bodies in order to
conduct their oath as though it were electric current.]

/ Herald: #block[
Will you swear on your honour (and on this book/sword/relic) to hold
#name and #name your rightful
Sovereigns, right until the end of Their lawful reign, and support their
royal might and justice?
]

/ Peers: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Peers: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Peers: #block[
I will.
]

/ Crown: #block[
And We in turn promise to grant you, the
- Peers of our Realm

- Royal Peers

- Knights

- Companions of the Order of the Laurel

- Companions of the Order of the Pelican

- Companions of the Order of Defence

and your households, all the rights and privileges of old, and to
protect you with the Law of the Realm.
]

/ Sovereign: #block[
So say We #name, Rex/Regina.
]

/ Consort: #block[
So say We #name, Rex/Regina.
]

#emph[Those peers who reserve their insignia until they have sworn may
replace their insignia.]

#emph[The peers retire.]

=== Homage for Territorial Prince(sse)s and Baron(esse)s

#emph[Those nobles who hold their lands in feof directly from the Crown
are called up to swear homage in order of precedence of the principality / barony.
At the time of compiling this edition, these territories are
the Principalities of Nordmark and Insulae Draconis and the Baronies of
Knights Crossing and Aarnimetsä. It is expected that Baronies within the
territories of Nordmark and Insulae Draconis will pay homage to their
Princes, who hold the lands directly in feof from the Crowns.]

#emph[For brevity, only Nordmark is written out in full; the others
follow suit. The landed nobles may have their own oaths instead of the
one suggested here.]

/ Herald: #block[
Let the Prince\[ss\] and Prince\[ss\] of Nordmark come forward to swear
homage.
]

/ Nordmark Herald: #block[
Make way, make way for #name and
#name, Prince\[ss\] and Prince\[ss\] of Nordmark!
]

#emph[The Coronets come forward as for homage, ungirt and bareheaded,
make reverence and kneel. Unlike fealty, homage is sworn with hands
between those of the overlord, so the Coronets put their hands between
those of their sovereigns.]

/ Nordmark Herald / Prince(ss): #block[
Let all present and to come know that we #name and
#name, Prince\[ss\] and Prince\[ss\] of Nordmark,
swear to be your vassals of life and limb and acknowledge verily to you
#name and #name, Sovereigns of
Drachenwald, that we hold and ought to hold. as a fief the Principality
of Nordmark. For this we make homage with hands and with mouth to you,
and we swear that we will always be faithful vassals to you in all
things in which a vassal is required to be faithful, and we will defend
you and the Kingdom and Principality against all malefactors and
invaders, and we will give you power over all the castles and manors in
the Principality, in peace and in war, whenever they shall be lawfully
claimed by you.

And if we do not observe to you each and all the things declared above,
and should come against these things, we wish that the aforesaid fief
should, by that very fact, be forfeit to you.
]

/ Coronets: #block[
So say I #name, Prince\[ss\].

So say I #name, Prince\[ss\].
]

/ Crowns: #block[
We receive the homage for the Principality of Nordmark, in the manner
you have sworn; and likewise We concede to you, the Prince\[ss\] and
Prince\[ss\] of Nordmark, all the castles and manors and places
aforesaid, as a fief. And We promise to you that We will be a good and
faithful liege concerning all those things described above.
]

/ Sovereign: #block[
So say We #name, Rex/Regina.
]

/ Consort: #block[
So say We #name, Rex/Regina.
]

=== Closing

/ Herald: #block[
There being no further business, I do hereby declare this court closed.
All rise for their \<adjective\> Majesties #name and
#name of Drachenwald!
]

#emph[The Crowns depart. During the procession the herald says the
following.]

/ Herald: #block[
Long live the \[King / Queen / Alt Title\]! Long live the \[King / Queen / Alt Title\]! Long live Drachenwald!
]

#emph[The territorial nobles may withdraw in state. The members of the
court may then withdraw as they please.]
]

#if sections.vii [
= Part VII Royal Peers
<part-vii-royal-peers>
The ceremonies assume that the reign that ended was either the first or
second for both of them, and that the former Consort had not already
reigned as Sovereign. If these assumptions do not hold please change the
wording as appropriate and omit sections that are not relevant.
]

#if sections.vii1 [
== 1. Investiture of Counties
<investiture-of-counties>
#emph[Adapt as necessary if only one person is receiving the rank.]

/ Herald: #block[
Their Majesties do hereby call before them #name and
#name, for they have greatly enriched our realm and
We would honour them.
]

#emph[They shall present themselves.]

/ Sovereign: #block[
#name, having won the Crown of this our beloved
realm and having ruled honourably as its Sovereign, we do hereby affirm
you as Count. Will you accept this honour from our hand?
]

/ Ex-sovereign: #block[
I will, Your Majesty.
]

/ Sovereign: #block[
In consensus with the Peerage, make known Our Royal will.
]

#emph[Herald reads Count\[ess\]’s scroll, hands it to the Sovereign. The
Sovereign hands it to the Count\[ess\].]

/ Consort: #block[
#name, having by your wisdom, grace, and virtue
inspired your champion to win for you the Royal Crown of this, our
beloved Kingdom and having ruled as its honourable Sovereign, We do
hereby affirm you as Count\[ess\]. Will you accept this honour from our
hand?
]

/ Ex-consort: #block[
I will, Your Majesty.
]

/ Consort: #block[
In consensus with the Peerage, let the scroll be read.
]

#emph[Herald reads Count\[ess\]’s scroll, hands it to the Consort. The
Consort hands it to Count\[ess\].]

/ Sovereign: #block[
Let their Excellencies receive the Coronets of their new rank.
]

#emph[Courtiers come forward from the Royal Entourage and kneel beside
the recipients. The Crowns stand up and take the Coronets from the
cushions. The Crowns hold the Coronets above the heads of their
Excellencies and place the coronets on their heads, as they says the
following.]

/ The Crowns: #block[
Be thou henceforth known as
]

/ Sovereign: #block[
Count\[ess\] #name.
]

/ Consort: #block[
Count\[ess\] #name.
]

#emph[The Crowns sit and usually make personal statements to their
Excellencies.]

#emph[If wanted:]

/ Count\[ess\]: #block[
Your Majesties, we would swear fealty to you.
]

#emph[Their Excellencies kneel before the Crowns, they place their hands
on the Sword of Stat., The Crowns place theirs above them.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, until the end of heir lawful reign, and support
their royal might and justice?
]

/ Count\[ess\]es: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Count\[ess\]es: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their realm?
]

/ Count\[ess\]es: #block[
I will.
]

/ Consort: #block[
And We in turn promise to grant you, Peers of our Realm, and your
households, all the rights and privileges of old, and to protect you
with the Law of the Realm.

So say We #name, Rex/Regina
]

/ Sovereign: #block[
So say We #name, Rex/Regina.
]

/ Herald: #block[
Count\[ess\] #name, you may depart;
Count\[ess\] #name, please remain.
]

#emph[The one stands, bows and departs.]

/ Herald: #block[
For Their Excellencies #name and
#name, Vivant! Vivant! Vivant!

#emph[Pause]

Their Majesties command the presence of all members of the Order of the
Rose.
]

#emph[Members of the order come forward and kneel.]

/ Herald: #block[
A rose is a glorious flower, worthy of all admiration, yet underneath
all its elegance it has fierce thorns to defend itself. Similarly, a
Consort inspires their subjects to noble deeds and fosters hospitality
but will, when necessary, defend their realm and subjects with all their
might.
]

/ Consort: #block[
#name, having ruled this Kingdom as its \[King /
Queen / Alt Title\], we confirm you as a Companion of the Rose.
]

#emph[The Consort gives a rose or a similar token.]

/ Sovereign: #block[
Let the new Companion of the Rose be vested as befits their rank.
]

#emph[Two members of the order place a cloak of the order around the new
member’s shoulders.]

/ Herald: #block[
For the new Companion of the Rose, #name, Vivat!
Vivat! Vivat!
]

#emph[The order departs.]
]

#if sections.vii2 [
== 2 Investiture of a Duchy
<investiture-of-a-duchy>
#emph[Adapt as necessary if only one person is receiving the rank.]

/ Herald: #block[
Their Majesties do hereby call before them #name and
#name, for they have greatly enriched our realm and
we would honour them.
]

#emph[They shall present themselves.]

/ Sovereign: #block[
#name, having twice won the Crown of this our
beloved realm and having twice ruled honourably as its Sovereign, We do
hereby affirm you as Duke/Duchess. Will you accept this honour from our
hand?

#emph[Alternative:]

#name, having won the Crown of this our beloved
realm and having ruled honourably as Sovereign of Drachenwald and of
#name, We do hereby affirm you as Duke/Duchess. Will
you accept this honour from our hand?
]

/ Duke/Duchess: #block[
I will, Your Majesty.
]

#emph[Courtier comes forward from the Royal Escort and kneels beside the
Duke/Duchess. The Sovereign stands, removes the County Coronet from
recipient’s head and places it on the cushion. The Sovereign sits.
Courtier stands up, bows before their Majesties and retires to the Royal
Escort.]

/ Sovereign: #block[
In consensus with the Peerage, make known our Royal will.
]

#emph[Herald reads the scroll, hands it to the Sovereign and the
Sovereign hands it to Duke/Duchess.]

/ Consort: #block[
#name, having by your wisdom, grace, and virtue
twice inspired your champion to win for you the Crown of this, our
beloved Realm and having twice ruled as its honourable Sovereign, We do
hereby affirm you as Duke/Duchess. Will you accept this honour from our
hand?

#emph[Alternative]

#name, having by your wisom, grace and virtue twice
inspired your champion to win for you the Crowns of the realms of
Drachenwald and #name, and having ruled each honourably
as Sovereign, We do hereby affirm you as Duke/Duchess. Will you accept
this honour from our hand?
]

/ Duchess: #block[
I will, Your Majesty.
]

#emph[Courtier comes forward from the Royal Escort and kneels beside the
Duke/Duchess. The Consort stands, removes the County Coronet from the
recipient’s head and places it on the cushion. The consort sits.
Courtier stands up, bows before their Majesties and retires to the Royal
Escort.]

/ Consort: #block[
In consensus with the Peerage, let the scroll be read.
]

#emph[Herald reads the scroll, hands it to the Coronet and the Coronet
hands it to Duke/Duchess.]

/ Sovereign: #block[
Let their Graces receive the Coronets of their new rank.
]

#emph[Courtiers come forward from the Royal Escort, with Ducal Coronets
on the cushions and kneel beside the recipients. The Crowns stand. The
Crowns take the Ducal Coronets from the cushions, hold them above their
Graces’ heads, and place the coronets on their Graces’ heads, as they
say the following.]

/ The Crowns: #block[
Be thou henceforth known as
]

/ Sovereign: #block[
Duke/Duchess #name.
]

/ Consort: #block[
Duke/Duchess #name.
]

#emph[The Crowns sit and usually make personal statements to the new
Dukes/Duchesses.]

#emph[If wanted:]

/ Duke: #block[
Your Majesties, we would swear fealty to you.
]

#emph[They kneel before the Sovereigns place their hands on the Sword of
State, and the Sovereigns place theirs above them.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, until the end of their lawful reign, and support
their royal might and justice?
]

/ Duke/Duchess: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Duke/Duchess: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm Their Realm?
]

/ Duke & Duchess: #block[
We so swear.
]

/ Consort: #block[
And We in turn promise to grant you, Peers of our Realm, and your
households, all the rights and privileges of old, and to protect you
with the Law of the Realm.

So say We #name, Regina
]

/ Sovereign: #block[
And so say We #name, Rex.
]

#emph[If the first reign of the outgoing Consort was as Sovereign,
insert the ceremony for the Order of the Rose here. Otherwise:]

#emph[Duke and Duchess stand up, bow and depart.]

/ Herald: #block[
For Their Graces #name and #name,
Vivant! Vivant! Vivant!
]
]

#if sections.viii [
= Part VIII Peerage Orders
<part-viii-peerage-orders>
]

#if sections.viii1 [
== 1. Order of Chivalry
<order-of-chivalry>
=== Invocation of the Vigil

/ Herald: #block[
Their Majesties command the presence of all members of the Order of
Chivalry.
]

#emph[The order comes forward.]

/ Monarch: #block[
Good my Peers, We seek counsel! Will you give us this?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Word has reached us that there is one amongst our people who is a Peer
in truth, but not in name. Is this so?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Let us summon the candidate.
]

/ Herald: #block[
Their Majesties command the presence of
#name.
]

/ Monarch: #block[
#name, your skill with arms is known to us, your virtues
beyond reproach. It is our wish to make you a member of the Order of
Chivalry.
]

/ Herald / Sponsor / Senior Chivalry: #block[
It is necessary that I address you, concerning aspects of Peerage and
Chivalry. It is often said that Peerage is an honour. It is surely that,
but further, it is a responsibility, which you should not take upon
yourself lightly, but with sobriety and sincerity. The oath you will be
offered will bind you in fealty to the Crown; and it is well that you
should understand what you are about to promise.

#emph[The next paragraph may be read by a Member of the Pelican:]

The Order of the Pelican is the order of Service, and yet, a Knight and
a Master of Arms must serve as well: not only the Crown, but the land as
a whole, each member of the Chivalry performing to the best of their
ability, and then to that point of performance where sacrifice is
required. A Peer must be willing to do good works, and must do then more
frequently and more extensively than their friends who are not Peers.

#emph[The next paragraph may be read by a Member of the Laurel:]

The Order of the Laurel is the order of the Arts and Sciences, but a
Knight and a Master of Arms must also encourage the Arts and Sciences,
not just by appreciating them, but by participating in their practice,
for what the strong arm of the warrior wins may be made barren and cold
by the battle; only the warm heart can nurture the land and its people
and bring them to their fullest potential.

#emph[The next paragraph may be read by a Member of the Defence:]

The Order of Defence is the order noted for its deadly art and
scholarship of weapons, but a Knight and a Master of Arms must be
equally skilled in diverse arts martial, either on a tourney field or in
war, always striving to become more skilled in the arts and practice
them with grace, and to teach those willing to learn.

#emph[Return to the Herald / Sponsor / Senior Chivalry]

The Knights and the Masters of Arms are the Order of Chivalry, and as
such, they stand as the foremost examples of gentle behaviour, valour,
and honour. A member of this Order must display equal grace in victory
and in defeat; he must not suffer injustice, but neither should he seek
vengeance; he must remember that as his reputation depends upon his
skill in delivering blows, so it also depends upon the way in which he
receives them. Be mindful that a Peer guides, not only by his word, but
also by the example he sets for others. Continue to live by the Code of
Chivalry: to protect the weak and defenceless; to respect and defend the
honour of ladies; and to teach these values to others that may seek the
true standard of Chivalry. The Code is your guide in your conduct with
others, whether they be fellow Peers, or the humblest member of the
populace; for indeed, the lowlier the station of those with whom you
treat, the greater is your influence over them. Deal with them justly
and fairly, regardless of station, be gracious and courteous to all, be
an example to whom others can look.

To accept elevation to the Peerage is to accept these responsibilities.
I pray you, keep these words in your heart, as you prepare for your new
status.
]

/ Monarch: #block[
Good peers, please escort #name to their
vigil to consider our offer and please give them your guidance and
counsel in this matter.
]

=== Induction into the Order of Chivalry

/ Herald: #block[
Their Majesties command the presence of the Chivalry.
]

#emph[Members of the Order assemble.]

/ Herald: #block[
Since ancient times it has been recognised that there are certain
warriors who are much deserving of high honour, not only by their skill
at arms, but by their noble behaviour, which has come to define the
meaning of Chivalry.

Therefore was created the Order of the Chivalry, to recognise those who,
possessing all the other skills, virtues and attributes appropriate to
members of the Peerage, shall also have distinguished themselves by
their prowess in armoured combat and chivalrous demeanour. The Order
consists of two equal parts, Knights and Masters of Arms.

And the symbols of Knighthood are a white belt and an unadorned chain,
while the symbol of Mastery of Arms is a white baldric. The white belt
and baldric betoken the honour with which the knight or master girds
himself, and the chain the fealty the knight swears. And this Order
ranks in precedence with the Orders of the Laurel, the Pelican, and
Defence. It carries with it a Patent of Arms.
]

/ Escort: #block[
Your Majesties, having consulted with the Order, is it your desire to
increase our numbers at this time?
]

/ Monarch: #block[
It is. Please bring the candidate forward.
]

#emph[Escort brings candidate forward.]

/ Escort: #block[
My liege, it is my privilege to present you #name,
that they may be made a member of our order.
]

#emph[At this point it is possible to have members of the peerage orders
to speak for the candidate:]

/ Herald: #block[
Not only the arts of Ssordmanship and eye of measure but also the
strength of arm and chivalry of heart make one a true warrior. Order of
Chivalry stands as primary of these attributes.
]

/ Monarch: #block[
Is there a member of the Order of the Chivalry to speak for the
candidate?
]

/ Knight / Master of Arms: #block[
#emph[Speaks about the chivalry and prowess in arms of the candidate.]
]

/ Herald: #block[
But whilst Force of Arms may defend a Realm, it does not make it
flourish. Without the Arts and Sciences, the land is bare and barren.
The Order of the Laurel is the Order of the Arts and Sciences. But to
appreciate what they fight for, a member of the Chivalry must have
knowledge of the Arts and Sciences.
]

/ Monarch: #block[
Is there a member of the Order of the Laurel to speak for the candidate?
]

/ Laurel: #block[
#emph[Speaks of the candidate in respect to their accomplishments in /
appreciation of arts and sciences.]
]

/ Herald: #block[
No matter the greatness of the Warrior or the Artisan, without Service,
they remain isolated, shared not with the Realm. The Order of the
Pelican is the Order of Service, but a member of the Chivalry must also
serve the Crown and the Realm.
]

/ Monarch: #block[
Is there a member of the Order of the Pelican to speak for the
candidate?
]

/ Pelican: #block[
#emph[Speaks of the service done by the candidate.]
]

/ Herald: #block[
By all manner of arms and combat the Kingdom is defended and championed.
While the Order of Defence is the Order of Steel, Swordsmanship and Art
of Arms, a member of the Chivalry is also a keen student and teacher of
these arts.
]

/ Monarch: #block[
Is there a member of the Order of Defence to speak for the candidate?
]

/ Defence: #block[
#emph[Speaks of the candidate’s long dedication, skill and inspiration
in the arts of combat and of his grace in field and court.]
]

/ Monarch: #block[
Is there a member of the Order of the Rose to speak for the candidate?
]

/ Herald: #block[
A warrior may be mighty, but without courtesy and honour they are no
Peer. The Order of the Rose speaks for courtesy and honour.
]

/ Rose: #block[
#emph[Speaks of the courtesy of the candidate.]
]

/ Herald: #block[
Drachenwald has many Peers, but many more who are not Peers, and their
voice is mighty, to be ignored at the peril of all! Is there a message
from the People of the Realm in regard to this candidate?
]

/ Representative of the populace: #block[
#emph[Speaks of the largesse, humility or fairness the candidate
exhibits in how he interacts with the rest of the society.]
]

#emph[Crown turns to the sponsor.]

/ Monarch: #block[
Do you, Sir/M\_\_\_ #name, and the other members of
your order affirm their worthiness for this high honour, accepting them
as your peer in chivalry, honour and valour upon the field?
]

/ Knights: #block[
I do.
]

/ Monarch: #block[
It is our judgement that the candidate fulfils all the requirements of
the Order of Chivalry.
]

/ Monarch: #block[
#name, well pleased with your prowess on the field
and your gentle conduct at all the times, responsive to the wishes of
your peers, we are minded to create you a member of the Order of
Chivalry. Will you accept from us this honour?
]

/ Candidate: #block[
I will, Your Majesty.
]

/ Monarch: #block[
Do you wish us to create you a Knight, and swear fealty to us, or would
you rather become a M\_\_\_ of Arms?
]

/ Candidate: #block[
#response
]

/ Monarch: #block[
Make known Our Royal will.
]

#emph[Herald reads scroll, hands it to Monarch. Monarch hands it to
candidate.]

=== In case the candidate opts for Knighthood

/ Monarch: #block[
Let the candidate’s sword be brought forward.
]

#emph[The candidate’s sponsor girds the candidate with the sword belt.
During this, the Crown adds the following words.]

/ Monarch: #block[
Remain forever worthy of this sword #name, and bear
in mind that a sword has two edges, Justice and Mercy.
]

/ Monarch: #block[
Let the candidate be vested with his spurs.
]

#emph[A member of the Chivalry puts the spurs on the candidate.]

/ Herald: #block[
Be mindful that a knight guides, not only by his word, but also by the
example he sets for others. Continue to live by the Code of Chivalry:
protect the weak and defenceless, respect and defend the honour of
ladies and teach these values to others that may seek the true standard
of knighthood.
]

/ Monarch: #block[
With what sword do you wish to be knighted?
]

#emph[Candidate answers, e.g. Sword of State, Sponsor’s sword, etc..
Monarch receives the named sword and if the Crown is not a knight, the
sponsor moves around to the right of the throne and lays his hand over
the Crown’s. The candidate is struck with the flat side, once on the
right shoulder, once on the left and then once on the top of head.
During this, a Crown says the following.]

/ Monarch: #block[
I dub thee once, I dub thee twice, I name thee Knight!

#emph[Pause.]

Sir #name, let this be the last blow you receive
without giving answer.
]

#emph[Crown delivers the buffet, preferably to the right shoulder,
firmly but not injuriously. The buffet may be left out completely if the
candidate has strong hesitations. The other Crown, if present, receives
the white belt and girds the knight with it.]

/ Monarch: #block[
Wear this belt, Sir #name, and keep it as you would
your honour, unblemished and unstained.
]

#emph[Crown receives Sword of State. Knight places his hands on the
sword, The Crowns place their hands upon knight’s hands.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Knight: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Knight: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Knight: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you and your household all the rights
and privileges of old, and to protect you with the law of the Realm.
]

/ Sovereign: #block[
So say We #name, Rex/Regina
]

/ Consort: #block[
So say We #name, Rex/Regina.
]

#emph[Crown receives chain. Crown hangs chain around knights neck, as
they say the following.]

/ Monarch: #block[
Take this chain, and let its weight ever remind you of the fealty you
have sworn.
]

=== In case the candidate opts for Mastery of Arms
/ Monarch: #block[
Let the candidate’s sword be brought forward.
]

#emph[The candidate’ sponsor girds the candidate with the sword belt.
During this, the Crown adds the following words.]

/ Monarch: #block[
Remain forever worthy of this sword #name, and bear
in mind that a sword has two edges, Justice and Mercy.
]

/ Monarch: #block[
Let the candidate be vested with his spurs.
]

#emph[A member of the Chivalry puts the spurs on the candidate.]

/ Herald: #block[
Be mindful that a Master of Arms guides, not only by his word, but also
by the example he sets for others. Continue to live by the Code of
Chivalry: protect the weak and defenceless, respect and defend the
honour of ladies and teach these values to others that may seek the true
standard of Chivalry.
]

#emph[Crown receives the white baldric and girds the m\_\_ with it.]

/ Monarch: #block[
Wear this baldric, M\_\_\_ #name, and keep it as you
would your honour, unblemished and unstained.
]

/ Monarch: #block[
Congratulations, Sir/M\_\_\_ #name. Go now to your
peers.
]
]

#if sections.vii2 [
== 2 Order of the Laurel
<order-of-the-laurel>
=== Invocation of the Vigil

/ Herald: #block[
Their Majesties command the presence of all members of the Order of the
Laurel.
]

#emph[The order comes forward.]

/ Monarch: #block[
Good my Peers, We seek counsel! Will you give us this?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Word has reached us that there is one amongst Our people who is a Peer
in truth, but not in name. Is this so?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Let us summon the candidate.
]

/ Herald: #block[
Their Majesties command the presence of
#name.
]

/ Monarch: #block[
#name, your skill in the arts and sciences is known to
us, your virtues beyond reproach. It is our wish to make you a member of
the Order of the Laurel.
]

/ Herald / Sponsor / Senior Laurel: #block[
It is necessary that I address you, concerning aspects of the Peerage.
It is often said that Peerage is an honour. It is surely that, but more,
it is a responsibility, which you should not take upon yourself lightly,
but with sobriety and sincerity. The oath you will be offered will bind
you in fealty to the Crown; and it is well that you should understand
what you are about to promise.

#emph[The next paragraph may be read by a Member of the Chivalry:]

The Knights and the Masters of Arms are the Order of Chivalry, but no
less chivalrous behaviour will be expected of you. As a Peer of the
Realm you must endeavour to live, as you have until now, by the rules of
courtesy and gentle behaviour. This courtly ideal is your guide in your
conduct with others, whether they be fellow Peers, or the humblest of
the populace; for indeed, the lowlier the station of those with whom you
treat, the greater is your influence over them. Deal with them justly
and fairly, regardless of station, be gracious and courteous to all, be
an example to whom others can look.

#emph[The next paragraph may be read by a Member of the Defence:]

The Order of Defence is the order noted for its deadly art and
scholarship of weapons, but you too are expected to apply to your own
art and scholarship with tenacity and grace, to defend what is right,
and to share your knowledge with those willing to learn.

#emph[The next paragraph may be read by a Member of the Pelican:]

The Order of the Pelican is the order of Service, but each Master and
Mistress of the Laurel, too, has the responsibility to serve: not only
the Crown, but the land as a whole, each Laurel performing to the best
of their ability, and then to that point of performance where sacrifice
is required. A Peer must be willing to do good works, and must do then
more frequently and more extensively than their friends who are not
Peers.

#emph[Return to the Herald / Sponsor / Senior Laurel.]

The Order of the Laurel is the Order most noted for artistry and
scholarship. Members of the Orders of Chivalry, Pelican, and Defence, as
Peers of the Realm, are expected to have some measure of artistic talent
or skill, but a Laurel exemplifies this talent to a degree far greater
than that of the other Peers, and greater still than that of the
populace at large. Rightly or wrongly, a Laurel is taken as an
authority, whose words carry considerable weight; do not therefore
choose your words lightly. Remember that just as your praise can
encourage a young artisan beyond any other force, your censure can crush
a budding talent of which the land may, by your actions, forever be
deprived.

To accept elevation to the Peerage is to accept these responsibilities.
I pray you, keep these words in your heart, as you prepare for your new
status.
]

/ Monarch: #block[
Good peers, please escort #name to their
vigil to consider our offer and please give them your guidance and
counsel in this matter.
]

=== Induction to the Order of the Laurel

/ Herald: #block[
Their Majesties command the presence of the Members of the Order of the
Laurel.
]

#emph[Members of the Order assemble.]

/ Herald: #block[
It has long been recognised that there are those among us who are much
deserving of high honour, but who, by reason of the nature and direction
of their services and achievement, come not to the glory of warrior or
throne, yet without whom our land would not be half so blessed.

Therefore was created the Order of the Laurel, to recognise those who,
possessing all the other skills, virtues and attributes appropriate to
members of the Peerage, shall also have distinguished themselves by
their outstanding achievement in the Arts and Sciences.

And the symbol of this Order is a medallion bearing a laurel wreath, for
the chaplet of laurel has long been acknowledged as a mark of superior
achievement, and this Order ranks in precedence with the Orders of
Chivalry, the Pelican, and Defence. It carries with it a Patent of Arms.
]

/ Escort: #block[
Your Majesties, having consulted with the Order, is it your desire to
increase our numbers at this time?
]

/ Monarch: #block[
It is. Please bring the candidate forward.
]

#emph[Escort brings candidate forward.]

/ Escort: #block[
My liege, it is my privilege, to present #name, that
they may be made a member of our order.
]

#emph[At this point it is possible to have members of the peerage orders
to speak for the candidate:]

/ Herald: #block[
Without the Arts and Sciences, the land is bare and barren, for only
they make the Realm flourish. The Order of the Laurel is the Order of
the Arts and Sciences.
]

/ Monarch: #block[
Is there a member of the Order of the Laurel to speak for the candidate?
]

/ Laurel: #block[
#emph[Speaks of the achievements of the candidate in the arts and
sciences.]
]

/ Herald: #block[
But while the arts and sciences enhance the Realm, it must be fostered
by strength and chivalry. The order of Chivalry stands as primary of
these attributes, but they are also required of a member of the Order of
the Laurel.
]

/ Monarch: #block[
Is there a member of the Order of Chivalry to speak for the candidate?
]

/ Knight: #block[
#emph[Speaks about the chivalry and/or prowess in arms of the
candidate.]
]

/ Herald: #block[
No matter the greatness of the Artisan or the Warrior, without Service,
they remain isolated, shared not with the Realm. The Order of the
Pelican is the Order of Service, but a member of the Order of the Laurel
must also serve the Crown and the Realm.
]

/ Monarch: #block[
Is there a member of the Order of the Pelican to speak for the
candidate?
]

/ Pelican: #block[
#emph[Speaks of the service done by the candidate.]
]

/ Herald: #block[
The Kingdom is defended and championed by many different arts. While the
Order of Defence is the Order of Steel, Swordsmanship and Art of Arms, a
member of the Order of the Laurel is also a keen student and teacher of
their own arts.
]

/ Monarch: #block[
Is there a member of the Order of Defence to speak for the candidate?
]

/ Defence: #block[
#emph[Speaks about the candidate’s grace and long dedication to the
art.]
]

/ Herald: #block[
An artisan may be skilled, but without courtesy and honour they are no
Peer. The Order of the Rose speaks for courtesy and honour.
]

/ Monarch: #block[
Is there a member of the Order of the Rose to speak for the candidate?
]

/ Rose: #block[
#emph[Speaks of the courtesy of the candidate.]
]

/ Herald: #block[
Drachenwald has many Peers, but many more who are not Peers, and their
voice is mighty, to be ignored at the peril of all! Is there a message
from the People of the Realm in regard to this candidate?
]

/ Representative of the populace: #block[
#emph[Speaks of the largesse, humility or fairness the candidate
exhibits in how he interacts with the rest of the society.]
]

#emph[Monarch turns to the sponsor.]

/ Monarch: #block[
Do you, M\_\_\_ #name, and the other members of your
order affirm their worthiness for this high honour, accepting them as
your peer in artistic and philosphic endeavour, and the other attributes
of peerage?
]

/ Laurels: #block[
I do.
]

/ Monarch: #block[
It is our judgement that the candidate fulfils all the requirements of
peerage and entry into the Order of the Laurel.
]

/ Monarch: #block[
#name, right mindful of your achievement and service
to our land, and responsive to the wishes of your peers, We are minded
to create you a M\_\_\_ of the Laurel. Will you accept from us this
honour and this badge of your achievement?
]

/ Candidate: #block[
I will, Your Majesty.
]

/ Monarch: #block[
Make known Our Royal will.
]

#emph[Herald reads scroll, hands it to Monarch. Monarch hands it to
candidate. Monarch receives the medallion from the provider, usually a
member of the Order. It is appropriate to here relate to the history of
the medallion, if any. Monarch places medallion around candidates neck,
as he says the following.]

/ Monarch: #block[
#name, take from our hands this token of your
achievement and our esteem. Henceforth be M\_\_\_
#name.
]

/ Monarch: #block[
Let the new M\_\_\_ be vested as befits their new rank.
]

#emph[A chaplet of laurel leaves is placed on the new peer’s head and a
Laurel’s cloak is placed around the peer’s shoulders, while the herald
says the following.]

/ Herald: #block[
From ancient times, the chaplet of laurel has been placed on the heads
of those worthy of special honour and recognition.

The cloak is the outward sign of the Laurel’s new status as a peer of
the realm.
]

/ Monarch: #block[
M\_\_\_ #name, is it your wish to swear fealty to us
at this time?
]

/ Laurel: #block[
#response
]

=== If yes:

#emph[Crown receives Sword of State. Laurel places their hands on the
sword, Crowns place their hands upon Laurel’s hands.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns right until the end of their lawful reign, and
support their royal might and justice?
]

/ Laurel: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Laurel: #block[
I do.
]

/ Herald: #block[
Will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Laurel: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you and your household all the rights
and privileges of old, and to protect you with the Law of the Realm.
]

/ Sovereign: #block[
So say We #name , Rex/Regina
]

/ Consort: #block[
So say We #name, Rex/Regina.
]

#emph[Crown raises new Member of the Laurel]

/ Monarch: #block[
Congratulations, M\_\_\_ #name. Go now to your
peers.
]
]

#if sections.viii3 [
== 3 Order of the Pelican
<order-of-the-pelican>
=== Invocation of the Vigil

/ Herald: #block[
Their Majesties command the presence of all members of the Order of the
Pelican.
]

#emph[The order comes forward.]

/ Monarch: #block[
Good my Peers, We seek counsel! Will you give us this?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Word has reached us that there is one amongst Our people who is a Peer
in truth, but not in name. Is this so?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Let us summon the candidate.
]

/ Herald: #block[
Their Majesties command the presence of
#name.
]

/ Monarch: #block[
My Lord/Lady/other appropriate title, your acts of service and counsel
are known to us, your virtues beyond reproach. It is our wish to make
you a member of the Order of the Pelican.
]

/ Herald / Sponsor / Senior Pelican: #block[
It is necessary that I address you, concerning aspects of the Peerage.
It is often said that Peerage is an honour. It is surely that – but
more, it is a responsibility, which you should not take upon yourself
lightly, but with sobriety and sincerity. The oath you will be offered
will bind you in fealty to the Crown; and it is well that you should
understand what you are about to promise.

#emph[The next paragraph may be read by a Knight or Master / Mistress of
Arms:]

The Knights and the Masters of Arms are the Order of Chivalry, but no
less chivalrous behaviour will be expected of you. As a Peer of the
Realm you must endeavour to live, as you have until now, by the rules of
courtesy and gentle behaviour. This courtly ideal is your guide in your
conduct with others, whether they be fellow Peers, or the humblest of
the populace; for indeed, the lowlier the station of those with whom you
treat, the greater is your influence over them. Deal with them justly
and fairly, regardless of station, be gracious and courteous to all, be
an example to whom others can look.

#emph[The next paragraph may be read by a Member of the Laurel:]

The Order of the Laurel is the order of the Arts and Sciences, but a
Pelican must also encourage the Arts and Sciences, not just by
appreciating them, but by participating in their practice, for the
greatest service you can render to your Land is to make it whole and
harmonious, and devoid of the beauty and braces of Art, that it cannot
be.

#emph[The next paragraph may be read by a Member of the Defence:]

The Order of Defence is the order noted for its deadly art and
scholarship of weapons, but you too are expected to serve and defend the
Crown and their realm with tenacity and grace, and to teach those
willing to learn the arts of maintaining this our Society.

#emph[Return to the Herald / Sponsor / Senior Pelican.]

The Order of the Pelican is unique among the four orders of Peerage.
Every Peer of the Realm, be they of the Order of the Chivalry, Laurel,
Defence or Pelican, has the responsibility to serve: not only the Crown,
but the land as a whole, each performing to the best of their abilities.
But the service expected of a Pelican is far greater than that expected
of the other Peers, and greater still than that expected of the populace
at large. You must be the first to offer your help, and the last to
accept reward; you must not falter when the task becomes more difficult
than you anticipated; and you must not remain content with your past
accomplishments, for although they are great, and for this reason are
you being created a Peer, it is by your future achievements that you
will be judged by those who seek to follow the example of a Peer.

To accept elevation to the Peerage is to accept these responsibilities.
I pray you, keep these words in your heart, as you prepare for your new
status.
]

/ Monarch: #block[
Good peers, please escort #name to their
vigil to consider our offer and please give them your guidance and
counsel in this matter.
]

=== Induction to the Order of the Pelican

/ Herald: #block[
Their Majesties command the presence of the Members of the Order of the
Pelican.
]

#emph[Members of the Order assemble.]

/ Herald: #block[
It has long been recognised that there are those among us who are much
deserving of high honour, but who, by reason of the nature and direction
of their services and achievement, come not to the glory of warrior or
throne, yet without whom our land would not be half so blessed.

Therefore was created the Order of the Pelican, to recognise those who,
possessing all the other skills, virtues and attributes appropriate to
members of the Peerage, shall also have distinguished themselves by
their sustained and exemplary service to the Society.

The symbol of this Order is a medallion bearing a Pelican in her Piety,
for as we all know, the Pelican will, when necessary, nourish her young
with blood from her own breast. Hence, the Pelican has come to represent
sacrifice, and become the symbol of the good servant. And this Order
ranks in precedence with the Orders of Chivalry, Laurel, and Defence. It
carries with it a Patent of Arms.
]

/ Escort: #block[
Your Majesties, having consulted with the Order, is it Your desire to
increase our numbers at this time?
]

/ Monarch: #block[
It is. Please bring the candidate forward.
]

#emph[Escort brings candidate forward.]

/ Escort: #block[
Your Majesty, it is my privilege, to present #name,
that they may be made a member of our order.
]

#emph[At this point it is possible to have members of the peerage orders
to speak for the candidate:]

/ Herald: #block[
No matter the greatness of the Warrior or the Artisan, without Service,
they remain isolated, shared not with the Realm. The Order of the
Pelican is the Order of Service.
]

/ Monarch: #block[
Is there a member of the Order of the Pelican to speak for the
candidate?
]

/ Pelican: #block[
#emph[Speaks of the service done by the candidate.]
]

/ Herald: #block[
But while service upholds the Realm, it must be done with strength and
chivalry. The order of Chivalry stands as primary of these attributes,
but they are also required of a member of the Order of the Pelican..
]

/ Monarch: #block[
Is there a member of the Order of the Chivalry to speak for the
candidate?
]

/ Knight: #block[
#emph[Speaks about the chivalry and/or prowess in arms of the
candidate.]
]

/ Herald: #block[
But whilst service may uphold a Realm, it does not make it flourish.
Without the Arts and Sciences, the land is bare and barren. The Order of
the Laurel is the Order of the Arts and Sciences. But to appreciate why
they serve the Kingdom, a member of the Pelican must have knowledge of
the Arts and Sciences.
]

/ Monarch: #block[
Is there a member of the Order of the Laurel to speak for the candidate?
]

/ Laurel: #block[
#emph[Speaks of the candidate in respect to their accomplishments in /
appreciation of arts and sciences.]
]

/ Herald: #block[
The Kingdom is defended and championed in many different ways. While the
Order of Defence is the Order of Steel, Swordsmanship and Art of Arms, a
member of the Order of the Pelican is also defending the Realm in their
own manner.
]

/ Monarch: #block[
Is there a member of the Order of Defence to speak for the candidate?
]

/ Defence: #block[
#emph[Speaks about the candidate’s grace and long dedication to the
kingdom and society.]
]

/ Herald: #block[
A servant may do great works, but without courtesy and honour they are
no Peer. The Order of the Rose speaks for courtesy and honour.
]

/ Monarch: #block[
Is there a member of the Order of the Rose to speak for the candidate?
]

/ Rose: #block[
#emph[Speaks of the courtesy of the candidate.]
]

/ Herald: #block[
Drachenwald has many Peers, but many more who are not Peers, and their
voice is mighty, to be ignored at the peril of all! Is there a message
from the People of the Realm in regard to this candidate?
]

/ Representative of the populace: #block[
#emph[Speaks of the largesse, humility or fairness the candidate
exhibits in how they interact with the rest of the society.]
]

#emph[Monarch turns to the sponsor.]

/ Monarch: #block[
Do you, M\_\_\_ #name, and the other members of your
order affirm their worthiness for this high honour, accepting them as
your peer in service and in the other attributes of peerage?
]

/ Pelicans: #block[
I do.
]

/ Monarch: #block[
It is our judgement that the candidate fulfils all the requirements of
peerage.
]

/ Monarch: #block[
#name, right mindful of your achievement and service
to Our land, and responsive to the wishes of your peers, We are minded
to create you a Member of the Pelican. Will you accept from us this
honour and the badge of your achievement?
]

/ Candidate: #block[
I will, Your Majesty.
]

/ Herald: #block[
Will you, to the best of your ability, continue in the cause of service,
as you most surely have until now, and seek to increase your labours and
talents nobly, and train any dependants you may have to do likewise, so
far as it is within your powers?
]

/ Candidate: #block[
I will.
]

/ Monarch: #block[
Make known our Royal will.
]

#emph[Herald reads scroll, hands it to Monarch. Monarch hands it to
candidate. Monarch receives the medallion from the provider, usually a
member of the Order. It is appropriate to here relate to the history of
the medallion, if any. Monarch places medallion around candidates neck,
as he says the following.]

/ Monarch: #block[
#name, take from our hands this token of your
achievement and our esteem. Henceforth be M\_\_\_
#name.
]

/ Monarch: #block[
Let the new M\_\_\_ be vested as befits their new rank.
]

#emph[A cap of maintenance is placed on the new peer’s head and a
Pelican’s cloak is placed around the peer’s shoulders, while the herald
says the following.]

/ Herald: #block[
Since times immemorial, the cap of maintenance is the symbol of the
Pelican, for just as the cap of maintenance supports the crown and makes
it easier to bear, so the Pelican supports the Kingdom and eases the
burden of its rulers.

The cloak is the outward sign of the Pelican’s new status as a peer of
the realm.
]

/ Monarch: #block[
M\_\_\_ #name, is it your wish to swear fealty to us
at this time?
]

/ Pelican: #block[
#response
]

=== If yes:

#emph[Crown receives Sword of State. Pelican places his hands on the
sword, The Crowns place their hands upon Pelican’s hands.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Pelican: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Pelican: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Pelican: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you and your household all the rights
and privileges of old, and to protect you with the Law of the Realm.

So say We #name, Rex/Regina
]

/ Monarch: #block[
So say We #name, Rex/Regina.
]

#emph[Crown raises new Master/Mistress of the Pelican.]

/ Monarch: #block[
Congratulations, M\_\_\_ #name. Go now to your
peers.
]
]

#if sections.viii4 [
== 4 Order of Defence
<order-of-defence>
=== Invocation of the Vigil

/ Herald: #block[
Their Majesties command the presence of all members of the Order of
Defence.
]

#emph[The order comes forward.]

/ Monarch: #block[
Good my Peers, We seek counsel! Will you give us this?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Word has reached us that there is one amongst Our people who is a Peer
in truth, but not in name. Is this so?
]

/ Order: #block[
Yes.
]

/ Monarch: #block[
Let us summon the candidate.
]

/ Herald: #block[
Their Majesties command the presence of
#name.
]

/ Monarch: #block[
#name, your skill with arms is known to us, your virtues
beyond reproach. It is our wish to make you a member of the Order of
Defence.
]

/ Herald / Sponsor / Senior Defender: #block[
It is necessary that I address you, concerning aspects of Peerage,
Courtesy and the Scholarship of Defence. It is often said that Peerage
is an honour. It is surely that -- but more, it is a responsibility,
which you should not take upon yourself lightly, but with sobriety and
sincerity. The oaths you will be offered will bind you in fealty to the
Crown; and it is well that you should understand what you are about to
promise.

#emph[The next paragraph may be read by a Member of the Pelican:]

The Order of the Pelican is the order of Service, and yet, a Master of
Defence must serve as well: not only the Crown, but the land as a whole,
each companion of the Defence performing to the best of their ability,
and then to that point of performance where sacrifice is required. A
Peer must be ready and willing to do good works, and must do them more
frequently and more extensively than their friends who are not Peers.

#emph[The next paragraph may be read by a Member of the Laurel:]

The Order of the Laurel is the order of the Arts and Sciences. The Art
of Defence may be the defining one for a swordmaster, but he too must
endorse and encourage the full field of Arts and Sciences, not only by
appreciating, but by participating in their practice, for what the
skills of a swordmaster might win may be made barren and cold by the
combat itself; only the warm heart can nurture the land and its people
and bring them to their fullest potential. Heed well the example of
teaching from the Companions of the Laurel, as that is the very art that
in addition to your own you will require to fully achieve the estate of
a mastery.

#emph[The next paragraph may be read by a Member of the Chivalry:]

The Knights and the Masters of Arms are the Order of Chivalry, but no
less chivalrous behaviour will be expected of you. As a Peer of the
Realm you must endeavour to live, as you have until now, by the rules of
courtesy and gentle behaviour. The courtly ideal is your guide in your
conduct with others, whether they be fellow Peers, or the humblest of
the populace; for indeed, the lowlier the station of those with whom you
treat, the greater is your influence over them. Deal with them justly
and fairly, regardless of station, be gracious and courteous to all, be
an example to whom others can look.

#emph[Return to the Herald / Sponsor / Senior Defender.]

The Order of Defence is the order noted for its deadly art and
scholarship of weapons. The swordmasters of the order stand as the
foremost examples of grace and form, not only in swordsplay but in all
manner of courtliness setting the standard of the gentles in our royal
courts. A companion of Defence, a swordmaster, must display equal grace
in victory and in defeat; he must not suffer injustice, but neither
should he seek vengeance; he must remember that as his reputation
depends upon his skill in delivering sure thrusts and clever cuts, so it
also depends upon the way in which he receives them. Be mindful that a
Peer guides, not only by his word, but also by the example he sets for
others.

As a swordmaster you need to continue your scholarship and study of not
only the Art of Defence and all others of the courtly arts as being a
Master is being a scholar who is now responsible for not only his own
improvement but of the improvement of others as well. Remember the
demands and dictates of courtesy, honour, and chivalry and being true to
the Order you are about to enter, defend them by your life, limb and
heart, both In fields of combat and halls of our Courts. Teaching the
love of them as well as your art to all those who look upon you for
guidance.

To accept elevation to the Peerage is to accept these responsibilities. I pray you, keep these  words in your heart, as you prepare for your new status.
]

/ Monarch: #block[
Good peers, please escort #name to their
vigil to consider our offer and please give them your guidance and
council in this matter.
]

=== Induction to the Order of Defence

/ Herald: #block[
Their Majesties command the presence of the Members of the Order of
Defence.
]

#emph[Members of the Order assemble.]

/ Herald: #block[
It has long been recognized that not only in the tournament combat and
melee, but in the study and practice of the Art of Defence as well, is
the true strength and prowess of the Kingdom forged. Since times of
antiquity has this art been practised, honed and taught by those first
amongst the swordsmen who have dedicated themselves to pursuit of the
mastery of steel. A number of these also possess the virtues we expect
and demand from the peers of our Society, they are much deserving of our
recognition and tribute, not only by their skills with true edge of
steel, but their nobility of heart, grace of their manner and service to
our realms as whole.

Therefore was created the Order of Defence, the fourth Order of the
Society bearing a Patent of Arms and ranking equally with the Orders of
Chivalry, Laurel and Pelican, to be bestowed on the worthiest of our
gentles when elevating them to the ranks of Peers of the realm. The
Order of Defence exists to recognize those of our Swordsmen, Warriors
and Scholars of the Arts of Arms who display not only these but also all
other qualities expected from the Peers of the Realm and who by their
love of Arts not only that of defence and their service and largesse
support these lands and the Crown.
]

/ Escort: #block[
Your Majesties, having consulted with the Order, is it Your desire to
increase our numbers at this time?
]

/ Monarch: #block[
It is. Please bring the candidate forward.
]

#emph[Escort brings candidate forward.]

/ Escort: #block[
Your Majesty, it is my privilege, to present #name,
that they may be made a member of our order.
]

#emph[At this point it is possible to have members of the peerage orders
to speak for the candidate:]

/ Herald: #block[
By all manner of arms and combat the Kingdom is defended and championed.
The Order of Defence is the Order of Steel, Swordsmanship and Art of
Arms.
]

/ Monarch: #block[
Is there a member of the Order of Defence to speak for the candidate?
]

/ Defence: #block[
#emph[Speaks about the candidate’s long dedication, skill and
inspiration in the art of defence and of his grace in field and court.]
]

/ Herald: #block[
No matter the greatness of the Warrior or the Artisan, without Service,
they remain isolated, shared not with the Realm. The Order of the
Pelican is the Order of Service, but a M\_\_\_\_\_\_ of Defence must
also serve the Crown and the Realm.
]

/ Monarch: #block[
Is there a member of the Order of the Pelican to speak for the
candidate?
]

/ Pelican: #block[
#emph[Speaks of the service done by the candidate.]
]

/ Herald: #block[
Not only Artfulness of Swordmanship and eye of measure but also the
strength of arm and chivalry of heart make one a true warrior. The Order
of Chivalry stands as primary of these attributes.
]

/ Monarch: #block[
Is there a member of the Order of the Chivalry to speak for the
candidate?
]

/ Chivalry: #block[
#emph[Speaks about the chivalry and/or prowess in arms of the
candidate.]
]

/ Herald: #block[
But whilst Force of Arms may defend a Realm, it does not make it
flourish. Without the Arts and Sciences, the land is bare and barren.
The Order of the Laurel is the Order of the Arts and Sciences. But to
appreciate what they defend, a M\_\_\_\_\_ of Defence must have
knowledge of the Arts and Sciences.
]

/ Monarch: #block[
Is there a member of the Order of the Laurel to speak for the candidate?
]

/ Laurel: #block[
#emph[Speaks of the candidate in respect to their accomplishments in /
appreciation of arts and sciences.]
]

/ Herald: #block[
A swords\_\_man may be mighty, but without courtesy and honour they are
no Peer. The Order of the Rose speaks for courtesy and honour.
]

/ Monarch: #block[
Is there a member of the Order of the Rose to speak for the candidate?
]

/ Rose: #block[
#emph[Speaks of the courtesy of the candidate.]
]

/ Herald: #block[
Drachenwald has many Peers, but many more who are not Peers, and their
voice is mighty, to be ignored at the peril of all! Is there a message
from the People of the Realm in regard to this candidate?
]

/ Representative of the populace: #block[
#emph[Speaks of the largesse, humility or fairness the candidate
exhibits in how he interacts with the rest of the society.]
]

#emph[Monarch turns to the sponsor.]

/ Monarch: #block[
Do you, M\_\_\_ #name, and the other members of your
order affirm their worthiness for this high honour, accepting them as
your peer in service and in the other attributes of peerage?
]

/ Defenders: #block[
I do.
]

/ Monarch: #block[
It is our judgement that the candidate fulfils all the requirements of
peerage.
]

/ Monarch: #block[
#name, right mindful of your achievement and service
to Our land, and responsive to the wishes of your peers, We are minded
to create you a M\_\_\_ of Defence. Will you accept from us this honour
and the badge of your achievement?
]

/ Candidate: #block[
I will, Your Majesty.
]

/ Herald: #block[
Will you, to the best of your ability, continue in the cause of service,
as you most surely have until now, and seek to increase your labours and
talents nobly, and train any dependants you may have to do likewise, so
far as it is within your powers?
]

/ Candidate: #block[
I will.
]

/ Monarch: #block[
Make known Our Royal will.
]

#emph[Herald reads scroll, hands it to Monarch. Monarch hands it to
candidate. Monarch receives the collar of the order from the provider,
usually a member of the Order. It is appropriate to here relate to the
history of the collar, if any. Monarch places the collar around
candidate’s neck, as he says the following.]

/ Monarch: #block[
#name, take from Our hands this token of your
achievement and Our esteem. Henceforth be M\_\_\_
#name.
]

/ Monarch: #block[
Let the new M\_\_\_ be vested as befits their new rank.
]

#emph[A cloak of the order is placed around the peer’s shoulders, while
the herald says the following.]

/ Herald: #block[
As a cape defends the body from cold, so defends a Master of Defence the
realm and crown. As the cape displays the sign of the Masters’ new
status as a peer of the realm, underneath it carries the symbol of the
Order of the Dragon’s Steel so the heritage of the Order of Defence in
the lands of Albion would not be forgotten.

The particular sign for a Master of Defence is the white collar of
maintenance where the collar’s pure colour symbolizes his honour,
intentions and aspirations the very name of the garment reminding him
how he as a peer, ought to maintain the realm, the crown and our common
ideals thus making the crown lighter to bear as he defends our
Sovereigns and their realm from all that might wish harm or slurs upon
the Golden shields of the Kingdom and Society.
]

/ Monarch: #block[
M\_\_\_ #name, is it your wish to swear fealty to us
at this time?
]

/ Candidate: #block[
#response
]

=== If yes:

#emph[Monarch receives Sword of State. The new peer places his hands on
the sword, the Crowns place their hands upon his hands.]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Candidate: #block[
I will.
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
them and their Realm, and support them in upholding the laws and
fulfilling their coronation oath?
]

/ Defence: #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Defence: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you and your household all the rights
and privileges of old, and to protect you with the Law of the Realm.

So say We \_\_\_\_\_\_\_\_\_\_\_\_ , Rex/Regina
]

/ Monarch: #block[
So say We \_\_\_\_\_\_\_\_\_\_\_\_ , Rex/Regina.
]

#emph[Crown raises the new Master/Mistress of Defence.]

/ Monarch: #block[
Congratulations, M\_\_\_ #name. Go now to your
peers.
]
]

#if sections.ix [
= Part IX Baronies
<part-ix-baronies>
In Drachenwald, baronage, both territorial and of the court, ranks
between peerage and grant-level awards. The ceremonies for investing
barons and baronesses are accordingly listed in the section of
grant-level awards. A Grant of Arms is often given with a court barony,
but this is not automatic and so must be explicitly proclaimed at court.
]

#if sections.ix1 [
== 1. Investiture of Landed Baronies
<investiture-of-landed-baronies>
=== Divestiture

#emph[If there were predecessor(s) to the Barony, this should be done
either right before the investiture or at an earlier court.]

/ Herald: #block[
The Barons of #name have asked for an audience, and
it is hereby granted.
]

#emph[The outgoing Barons come forward and kneel.]

/ Barony: #block[
Your Majesties, we have now served You and your predecessors as the
Barons of #name for #name years,
and we would retire from this office.
]

/ Monarch: #block[
#emph[Thanks the outgoing Barony.]
]

#emph[Royal retainers come forward with pillows. The outgoing Baronies
take off their coronets and hand them to the Crown, who put them on the
pillows. The retainers retire, and after a short pause so do the
ex-Barons.]

/ Herald: #block[
For #name and #name, former Barons of
#name, Vivat! Vivat! Vivat!
]

=== Investiture

/ Herald: #block[
Their Majesties call forward #name.
]

#emph[The incoming Barons come forward and kneel.]

/ Monarch: #block[
It is Our wish to create you the Barons of #name.
Will you accept this from us, and swear fealty to us?
]

/ Barons: #block[
I will.
]

#emph[Royal retainers come forward with the baronial coronet(s) on
pillow(s). If there are both a Baron and a Baroness, the Crowns both
take a coronet and as simultaneously as possible put the coronet on the
head of one of them, saying]

/ Crowns (one per Baron): #block[
#name, be Baron(ess) of #name.
]

#emph[The Crowns receive the Sword of State. The Barons place their
hands on the sword, and the Crowns their hands upon the Barons.]

/ Herald: #block[
Do you #name, Barons of #name,
acknowledge verily to these #name and
#name, Sovereigns of Drachenwald that you hold and
ought to hold as a fief the Barony of #name, and
make for the same homage and fealty with hands and with mouth to these
your Sovereigns?
]

/ Barons: #block[
I do.
]

/ Herald: #block[
Do you swear that you will always be a faithful vassal to their
Majesties in all things in which a vassal is required to be faithful,
and defend Them and the Kingdom and #name against all
malefactors and invaders, and give their Majesties power over all, or
any portion of, the castles and manors in their fief, in peace and in
war, whenever they shall be lawfully claimed?
]

/ Barons: #block[
I so swear.
]

/ Herald: #block[
And if you do not observe to their Majesties each and all the things
declared above, and should come against these things, the aforesaid fief
should by that very fact be forfeit to their Majesties.
]

/ Barons: #block[
I so swear.
]

#emph[The Crowns raise the Barons.]

/ Herald: #block[
To #name and #name, Barons of
#name.
]

#emph[\[Followed by a cheer of some description.\]]
]

#if sections.ix2 [
== 2. Investiture of a Court Baron / Baroness
<investiture-of-a-court-baron-baroness>
/ Herald: #block[
Their Majesties call forward #name.
]

#emph[The recipient comes forward and kneels.]

/ Monarch: #block[
It is our wish to create you the Baron(ess) of our court Will you accept
this from us?
]

#emph[This is one of the times to reveal the Coronet, if there is one,
permanent or temporary.]

/ Baron(ess): #block[
I will.
]

/ Monarch: #block[
Let the scroll be read.
]

#emph[Herald reads the scroll and hands it to a Monarch.]

/ Monarch: #block[
Let Their Excellency receive the Coronet of their new rank.
]

#emph[A royal retainer can come forward with the baronial coronet on a
pillow, or the Crowns may already have it via their attendants. A
Monarch takes it and puts it on the head of one of them, whilst they
say:]

/ Monarch: #block[
#name, be Baron(ess) of our Court of Drachenwald.
]

/ Monarch: #block[
Baron(ess) #name, is it your wish to swear fealty to
us at this time?
]

/ Baron(ess): #block[
#response
]

=== If yes:

#emph[The Crowns receive the Sword of State. The Baron(ess) place their
hands on the sword, and the Crowns their hands upon the Baron(esse)s. ]

/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Baron(ess): #block[
I will
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
Them and their Realm, and support Them in upholding the laws and
fulfilling their coronation Oath?
]

/ Baron(ess): #block[
I do.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Baron(ess): #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you and your household all the rights
and privileges of old, and to protect you with the Law of the Realm.

So say We #name, Rex/Regina
]

/ Monarch: #block[
And so say We #name, Rex/Regina.
]

#emph[The Crowns raise the Baron(ess).]

/ Herald: #block[
To #name, Baron(ess) of the Court of Drachenwald,

Vivat! Vivat! Vivat!
]
]

#if sections.x [
= Part X Grant of Arms Level Awards
<part-x-grant-of-arms-level-awards>
*Court Note:* Ring and Wing sound almost identical in English,
especially in the probably imperfect acoustics of a court. Sometimes the
entire Ring may be addressed and others just those of the Wing. Make
sure that it is very clear which is being referred to. I, Nicholas, have
in the past already been caught out once by mishearing this in court.

There is no formal ceremony for giving a plain Grant of Arms. The normal
method is for the person to be called to the Royal presence; the Crown
then has the opportunity to talk about the accomplishments of the
person, after which the herald reads the scroll and calls for vivats.

Bear in mind that granting arms is specific to certain places and times
within period. It is acceptable to substitute an equivalent type of
ceremony and scroll to suit the recipient’s persona.

The three grant level orders listed here rank above a plain Grant of
Arms, and if the recipient has not already got a Grant of Arms it comes
by Kingdom law automatically with the membership in the order. In such a
case, this should be proclaimed at court, for example by reading the
scroll that mentions the fact explicitly.

It is traditional for the existing members of an Order to make
themselves known, either by being called forward, or more commonly as
they increase in size, by simply standing in place. Neither is
mandatory, and an easy win when faced with a long court is to omit this
part.

In some Kingdoms it is traditional to style gentles with a grant of arns
as Honorable Lord/Lady. This is not an official title of the SCA, and
whilst not officially recognised within Drachenwald, there is no barrier
to using this style, especially if the holder or recipient desires it.

/ Herald: #block[
#emph[This introduction can be dispensed with if time is short.]

Drachenwald is rich with stories of rings. Rings of might, circles of
knights and rings of legend: some made by gods of old, others forged by
men seeking to build a better world and live by the greatest of ideals.
Thus inspired, the rulers of Drachenwald added to this long tradition by
creating our Kingdom’s own Order of the Ring, called in Latin, Ordo
Annuli. This order is the circle of trust and protection around our
Crown, this order is the circle of pillars supporting the thrones and
this order is the chaplet of stars resting on the royal brow. The order
is one unified circle, composed of three entwined companies of
greatness.

#emph[This ordering is arbitrary, and can be changed as appropriate or
just to reinforce that no company is greater than the others.]

The Order of the Swallow, formally called Ordo Hirundinis, whose
companions are noted for their service and diligence. The Order of the
Swan, formally called Ordo Cygni, whose companions are noted for the
grace of their art and philosophy. The Order of the Wing, formally
called Ordo Alae, the Crown’s allies in deeds of arms, noted for their
prowess and courage.

#emph[For longer courts, depending on which orders are being presented,
and in what order, it may expedient to call upon the entire Order of the
Ring, or just the Company specifically involved.]
]

/ Herald: #block[
#emph[Be very clear here, where required, to distinguish between 'Ring'
and 'Wing', hence why including the Latin form is a good idea.]

Their Majesties call forth all companions of Ordo Annuli, the Order of
the Ring, to bear witness and stand by them in their following deeds.1

#strong[or]

Their Majesties bid all companions of Ordo Annuli, the Order of the
Ring, to stand or make themselves known to witness their following
deeds.

#strong[or]

#emph[Substitute a specific order in one of the forms above.]

Their Majesties call before them \[Title\] #name.
]

#emph[The recipient kneels before the Crown.]

/ Monarch: #block[
We are well pleased with

- your prowess and courage on the field,
- your skills in the arts and philosophy,
- your service, diligence,

and your gentle conduct at all the times. Thus we are minded to create
you a Companion of the

- Wing
- Swan
- Swallow

and, through that Company, create/confirm you as a member of the Order
of the Ring.

Make known our command.
]

/ Herald: #block[
#emph[Reads the scroll text and hands it to the Crown.]
]

#emph[A token appropriate to the company is given to the Crown, either
by an attendant or one of the appropriate Company. The Crown then
bestows the token.]

/ Monarch: #block[
#name, take from Our hands this token of your achievement
and rank, and of Our esteem. Henceforth you are a Companion of the Ring.

Go forth and greet your companions.
]

/ Herald: #block[
#emph[Note a pre-existing title may trump that below.]

For \[the Honorable\] Lord/Lady #name. Vivat! Vivat!
Vivat!
]
]

#if sections.xi [
= Part XI Award of Arms Level Awards
<part-xi-award-of-arms-level-awards>
There is no formal ceremony for giving a plain Award of Arms. The normal
method is for the person to be called to the Royal presence; the Crown
then has the opportunity to talk about the accomplishments of the
person, after which the herald reads the scroll and calls for vivats.

Bear in mind that awarding arms is specific to certain places and times
within period. It is acceptable to substitute an equivalent type of
ceremony and scroll to suit the recipient’s persona.

The three armigerous orders listed here rank above a plain Award of
Arms, and if the recipient has not already got an Award of Arms it comes
by Kingdom law automatically with the membership in the order. In such a
case, this should be proclaimed at court, for example by reading the
scroll that mentions the fact explicitly.

It is traditional for the existing members of an Order to make
themselves known, either by being called forward, or more commonly as
they increase in size, by simply standing in place. Neither is
mandatory, and an easy win when faced with a long court is to omit this
part.
]

#if sections.xi1 [
== 1. Orden des Lindquistringes
<orden-des-lindquistringes>
/ Herald: #block[
Their Majesties command all members of the Orden des Lindquistringes to
stand / come forward..
]

#emph[The members do as they are bid.]

/ Herald: #block[
As the Crown serve the people of Drachenwald throughout their reign,
they set the example of service for all their subjects. All those who
enjoy the beauty and prosperity that is Drachenwald are expected to
render service when required, to the best of their abilities.

There are those few, however, whose service consistently exceeds the
expectations of their offices or ranks and who are, therefore,
especially worthy of reward.

The Orden des Lindquistringes was created to honour the memory of one
whose great honour and service helped to build our beloved land. It is
given to those persons who have served Drachenwald above and beyond the
normal contributions of a loyal subject.

And so do Their Majesties call before Them #name.
]

#emph[Recipient comes forward, bows and kneels. The Crowns may make
personal statements.]

#emph[Herald reads scroll and hands it to a Crown. The Crown names the
artist of the scroll, shows it to the populace and hands it to
recipient. The Crowns raise the recipient.]

/ Herald: #block[
For #name, the newest member of the Orden des
Lindquistringes, Vivat! Vivat! Vivat!
]
]

#if sections.xi2 [
== 2. Order of the Panache
<order-of-the-panache>
/ Herald: #block[
Their Majesties command all members all members of the Order of the to
stand / come forward..
]

#emph[The members do as they are bid.]

/ Herald: #block[
As the Crown reward service and valour, so too do they seek to encourage
the development of artistic skills and philosophic expertise among their
subjects. When a person has excelled consistently in the Arts or Natural
Phiosophy, and has shared that beauty and knowledge with others, it
becomes not only the duty, but the joy of the Crown to recognize such
endeavour.

Therefore was created the Order of the Panache, to be given as a sign of
the Crown’s recognition of the exceptional skill with which these
individuals increase the beauty and wisdom of Drachenwald.

And so do their Majesties call before Them #name.
]

#emph[Recipient comes forward, bows and kneels. The Crowns may make
personal statements.]

#emph[Herald reads scroll and hands it to a Crown. The Crown names the
artist of the scroll, shows it to the populace and hands it to
recipient. The Crowns raise the recipient.]

/ Herald: #block[
For #name, the newest member of the Order of the
Panache, Vivat! Vivat! Vivat!
]
]

#if sections.xi3 [
== 3. Order of the Silver Guard
<order-of-the-silver-guard>
/ Herald: #block[
Their Majesties command all members all members of the Order of the to
stand / come forward.
]

#emph[The members do as they are bid.]

/ Herald: #block[
Many a noble warrior has donned armour in order to pursue their fortunes
upon the tourney field, defend their land from a foe or follow their
Lord as sworn by oath.

There are those, however, whose prowess in combat inspires their
companions-at-arms and whose noble demeanour brings glory and honour to
Drachenwald. These are especially deserving of reward.

Thus does the Crown recognises such individuals by admitting them to the
Order of the Silver Guard, that all may know these gentles and be
instructed by their example

And so do Their Majesties call before them #name.
]

#emph[Recipient comes forward, bows and kneels. The Crowns may make
personal statements.]

#emph[Herald reads scroll and hands it to a Crown. The Crown names the
artist of the scroll, shows it to the populace and hands it to
recipient. The Crowns raise the recipient.]

/ Herald: #block[
For #name, the newest member of the Order of the
Silver Guard, Vivat! Vivat! Vivat!
]
]

#if sections.xii [
= Part XII Non-Armigerous Awards
<non-armigerous-awards>
For all these awards, after the recipients are called to the court, the
Crown may address them. After this, the herald reads a scroll, if there
is one, and the Crown hands the recipient the scroll or a token. While
the recipient retires from the presence, the herald calls for vivats.
]

#if sections.xii5 [
== 5. The Order of the Companions of Albion
<the-order-of-the-companions-of-albion>
#emph[This is a very long ceremony. It is not recommended in full for
courts which will be long for other reasons.]

/ Herald: #block[
In the years before history was recorded in our land, in a dark forest
to the North, called in German the "Schwarzwald", which means the "Black
Forest", there lived an ancient black dragon whose name was Albion. And
it was in this forest one winter’s day that Albion came across a young
boy. He was but fifteen and he was Prince of the land, and his name was
Yustav, and he was crying.

And Albion said, "Your Highness, why dost thou sit so in the winter
snow?"

Yustav said, "Friend Albion, tomorrow my people go off to hunt, and they
would have me be a great hunter, but try as I might, I cannot catch a
deer nor kill a fowl, and how shall I be a great Prince if I cannot
hunt?"

Albion pondered this a moment, and then with a great wrenching of his
mighty jaws, he severed the tail from his body, and he burned it in the
fiery flame of his breath. He said unto Yustav, "Take this, my tail, and
use it as a spear, and with it you shall kill the swiftest deer, the
largest boar, and you shall be hailed in all the lands as the greatest
hunter."

Yustav took the spear upon him, and he went off to the hunt, and when he
had returned what Albion had told him was true, for he had killed the
swiftest deer, the largest boar, and he was hailed in all the lands as
the great hunter.

Whereupon ten years went by, and Albion came upon a somewhat older
Prince, now twenty-five, who was sitting in the snow, weeping.

And Albion said, "Your Highness, why dost thou sit weeping in the snow?"

And Yustav said, "Friend Albion, tomorrow my people go to war, but I
fear for my life. If only my skin were as hard as yours, then I would be
courageous in combat, and fearing no enemy, I could be a warrior. How
can I be Prince if I cannot fight?"

Albion pondered this for a moment, and then with a mighty clenching of
his claws, he ripped the scales from his flesh, and he heaped them in a
pile before Yustav, saying, "Your Highness, take these my scales. Have
them sewn onto a coat, and you shall have the finest armour in all the
lands. You will be untouchable in battle. Fearless, you will be hailed
as the greatest warrior."

Yustav took up the scales unto him, took them to his armourer and had
them made into a suit of armour. When he returned from the wars, what
Albion had told him was true. Fearless in combat, knowing that no blade
could touch him, no axe could reach him, he killed the largest number of
enemies and was hailed as the greatest warrior.

Twenty years went by, and Albion, a little worse for wear with no tail
and no scales, came across the now mature Prince of forty-five who was
sitting in the snow, brooding.

And he said, “ Your Highness, why dost thou sit so stern of face and
pale of countenance?”

And Yustav said, "Friend Albion, I would take me a wife, but the lady
that I would have is of great wealth and stature. There is nothing I can
give her which she does not already possess. How can I be a Prince if I
do not have a Princess?"

Albion pondered this a moment, and then with a mighty clenching of his
claws he wrenched the teeth from his very mouth, and he placed them
before the Prince, saying, "Your Highness, take these, my teeth. Have
them placed in placards of ivory and you shall have the finest combs in
all the land to gift your lady with."

Yustav took up the teeth from him, and had them made into fine combs,
and his Princess agreed to marry him, and he lived happily.

Whereupon twenty years went by, and Albion, much weaker, much smaller
than before, for with no teeth he could catch only the smallest of field
mice, the slowest of fowl, came across a now ageing Prince of
sixty-five, who sat shivering in the snow.

And he said, "Your Highness, why dost thou sit here so coldly in the
snow?"

Yustav said, "Friend Albion, my bones grow old, and the winters are
cold. There is no heat to warm the inner ice. I fear that soon shall I
die."

Albion pondered this a moment, and then with his razor-sharp claws he
plucked the heart from his breast, and placed it before the Prince,
saying, "Your Highness, take this, my heart. Have it made into a fine
robe, for there is nothing warmer in all the lands. Wear it and you
shall live."

Yustav took up the giant heart and had it made into a robe, and the
dragon’s words again were true, for Yustav did live.

Ten years went by, and Yustav awoke, and he realised that after all the
years, after all the gifts that Albion had given him, so unselfishly, so
chivalrously, not once, not once had the Prince thanked him. And he
grieved. He told his son, Wilhelm, who would soon be Prince, that he
would seek out a friend in the Schwarzwald, and there he went to find
his friend, Albion.

Now, as we all know, a dragon may live without scales, or tail, or even
teeth, but without a heart the essence, which is the magic of a dragon,
is no more, and all that remains are the bones left by the vultures and
the dragon’s claws. And that is what Yustav found there in the clearing
of Albion - the many scattered bones left by the vultures and predators,
and the many sable claws of Albion. The Prince fell to his knees and
wept.

After many hours, Wilhelm called for a search to find his father, but it
was Wilhelm himself who found the Prince there in the landing. He took
his father into his arms, and with dying words and rasping breath,
Yustav told Wilhelm the story of Albion and of his many gifts, whereupon
he died.

Wilhelm took up his father and laid on a great funeral, and he was
shortly thereafter made Prince of the land. His first official act as
Prince was to make dragons a protected species in the land.

After many years the people, having heard the legend of Albion, lost the
old name of their land and took up a new and popular one, calling
themselves "Drachenwald", meaning in the German the "Dragon Forest", and
Albion became the symbol of this land.

The new Prince, who was called Richard, thought that in some manner he
should make his memory lasting, and so he created an Order, into which
could be admitted only those who their own interests could forget while
serving others. So chivalrous, so noble, so true must they be that they
would be likened by their peers to the memory of Albion. And he styled
the Order "The Royal Order of the Companions of Albion" and he took as
its symbol a sable claw of the great dragon. Following the tradition of
the Princes of Drachenwald and of the great Albion himself, do the
Sovereigns of Drachenwald reward their most faithful servants, even to
this very day.

#emph[Pause.]

And so does their Majesty call before them #name.
]

#emph[(The Albion story was written by Viscount Richard Gilchrest, who
created the Order during his reign as Prince.)]
]

#if sections.xii6 [
== 6. The Order of Courtesy
<the-order-of-courtesy>
#emph[This is a very long ceremony. It is not recommended in full for
courts which will be long for other reasons.]

/ Herald: #block[
Long ago, the lands of Drachenwald were forged into a mighty Kingdom,
and in the King’s, army was a virtuous but impoverished noble. One day
in the fierce heat of battle, a foul arrow struck them under the arm,
where they were lightly armoured, and they fell. The chirurgeon, knowing
the esteem in which the noble was held, worked long into the night to
save them. Eventually, the arrowhead was withdrawn, but it was clear
that they could play no further part in that campaign.

"A good and courteous subject," said the King to His Queen, "but they
are now of no use to us. Lay them in a carriage and send them home to
retire."

When the noble awoke from their fever, the Queen went to them and said,
"Your service has been gallant, but in your condition, you can no longer
fight. You have leave to depart." They could not stand, but the noble
sat up and said, "Your Majesty, I can no longer wield my sword, yet I
beg that I be allowed to stay so that I may be of use wherever I can,
for my heart still beats with a love of Drachenwald."

And so the noble followed the army. Their pain and misery at being
unable to fight alongside their King and Queen in the front rank was
almost beyond endurance.

But, the Queen noted, not once did they complain. They made their bed in
the open, along with the servants, shared their meagre rations without
demur, fetched firewood and stirred the pot alongside the lowliest cook.

As the wound began to heal, they took up further tasks. They rode with
messages or on errands for the Sovereigns. Even when requests for
assistance were made by the lowliest servant, it was greeted with a
smile and left with a charming farewell. Never did they think of their
own needs, but rather always saw the world through the eyes of those
around, anticipating their needs and making their burdens less
wearisome.

Some of the maids had children that ran about their feet whilst they
tried to work. The noble began to look after the children for a while
each day, so that the ladies might have peace. He taught the children
games and skills that would be of benefit to them in later life, and he
told them moral tales. These children came from the humblest families –
yet this noble treated them all with the same grace and courtesy as if
they had been the children of the King and Queen themselves.

One day, the army was passing through a region of high mountains in
terrible weather. Thunder shook the walls of rock around them, and
lightning flashed overhead. Rain turned every stream into a torrent
laden with fallen branches and tumbling rocks.

The Queen turned to one of her ladies-in-waiting, asking, "Where is that
kind and gracious noble who was wounded? I would have them organise our
camp for tonight."

A while later, the lady returned, saying "Your Majesty, it grieves me to
tell you, but that gentle is nowhere to be found."

The Queen ordered, "Search the army and find this noble indivduak, for
they are of great service to me, and I would have him at my side."

Eventually, a young peasant was brought before the Queen.

"Your Majesty," he said, "it is my fault that your noble servant is not
here. Please forgive me."

"Do not be afraid," said the Queen, "just tell me what has happened."

"I am a goatherd," said the youngster, "and my flock provides your
Majesty with fine cheeses and fresh milk. But this morning, when this
terrible storm arose, my animals took fright and scattered. Your noble
servant found me crying at my plight, and immediately set off to find my
goats although the thunder threatened to blast them from those dreadful
rocks." The child turned and pointed to a rocky ridge that climbed
thousands of feet to be lost in the clouds.

The King said to the Queen "They risk their life even for a mere
peasant, and had they already returned, we would never have known of
their toil. But they have always been so."

The Queen replied, "it is true that even the greatest deeds can pass
unnoticed. But now, we must find our noble friend, for they are in grave
danger in this storm. I beg you to find them."

Patrols were sent into the mountains, and at length, a trumpet call
sounded. Their Majesties mounted their steeds, and clambered up the
treacherous paths, until they found the soldiers.

"Look!" called the sergeant-at-arms, pointing further ahead. And there,
descending through the mist, with staff in hand, guiding a flock of
goats, was the noble friend, singing a jaunty song in defiance of the
storm.

Surprised to be greeted by such a retinue, they bowed deeply. "Your
Majesties," they said, "surely you cannot be here on my account. How may
I help you?" They spread their arms wide, and their Majesties could see
both hands were cut and grazed from the perilous climb.

The King spoke. "Noble warrior, I can see your strength has returned,
and your courage has evidently not faltered, so you may rejoin the army
with my blessing."

The Queen smiled. "Noble servant," she said, "We came in search of one
whose values we would protect. You never complain at your misfortunes.
Not once have you sought attention at the expense of others. Unseen, you
work to ensure that the honour of Drachenwald and its people is upheld.
But in particular, it is the unstinting courtesy that you have shown to
young and old, to high and low-born alike, that has made this long
journey and difficult task not a labour, but a joy, and for that we
thank you."

With this, the Queen noticed something in the noble herder’s belt. "What
is that flower caught in your clothing?" she asked.

The noble saw that an edelweiss was lodged in their buckle, so they
handed it to the Queen. As they did so, a drop of his blood stained its
centre. "It is an edelweiss, your Majesty, that grows only on the
highest peaks, for it was there that I found the goats, sheltering from
the gale."

The Queen turned to her husband, saying "Your Majesty, I beg of you this
boon. The honours of Drachenwald are mostly in your gift, but I would
ask that I, too, may create an Order to which only the most worthy may
be admitted."

"So be it," replied the King, "know you all that I grant Her Majesty
this wish."

The Queen spoke again. "Noble friend, your courtesy and love of
Drachenwald is an example to us all and is almost beyond reward. But let
this flower be now worn as a rare badge of honour, for the Consorts of
Drachenwald alone to bestow, from now until the world ends."

And so she pinned the edelweiss to the noble’s breast, and charged them
to promote the study of courtesy for as long as they should live.

And so from that time forth, exceptional individuals have been inducted
into the Order of Courtesy, in this fashion, either as a pin or on a
silver chain: an edelweiss argent eyed gules.

#emph[Pause.]

And so does their Majesty call before them #name.
]

#emph[(The story was commissioned by Queen Honor of Restormel and
written by Lord Heinrich von Westfelsen.)]
]

#if sections.xii7 [
== 7. Sigilla Coronarum
<sigilla-coronarum>
=== By both Sovereign and Consort together

/ Herald: #block[
The duties and responsibilities of the Crown are many. Our Sovereign by
blood must be a source of strength and wisdom for the people. They must
be foremost in valour upon the battlefield, yet gentlest in courtesy of
any in the Realm. Their Consort must be a patron of artists and
philosophers. They must be the embodiment of gentle grace, courtesy,
virtue and love that her subjects deserve. Together, as one, they must
govern and rule this land.

Although our Sovereigns are supported by all loyal subjects whose
service they may command, there are those subjects without whom they
could not rule half so joyously, for their constant attention to Royal
needs makes light the day-to-day details of ruling and their tireless
devotion serves to ease the burden of Royal responsibilities.

Therefore was created the Sigillum Coronae, to recognise those
individuals, whose personal service to the Crown far exceeds any
expected measure. And the badge of the award shall be a white Edelweiss
surmounted by a black dragon’s head bearing the sigils of the Crown
bestowing it.

So now do their Majesties call before them #name.
]

=== Sigillum Coronae/Regis/Reginae (by the Sovereign)

/ Herald: #block[
The duties and responsibilities of a Sovereign are many. They must
govern and rule the land. They must be a source of strength and wisdom
for their people. They must be foremost in valour upon the battlefield,
yet gentlest in courtesy of any noble in the Realm.

Although They are supported by not only their Inspiration, but by all
loyal subjects whose service They may command, there are those of Their
subjects without whom the Crown could not rule half so joyously, for
their constant attention to Their needs makes light the day-to-day job
of ruling and their tireless devotion serves to ease the burden of Royal
responsibility.

Therefore was created the Sigillum Coronae, to recognise those
individuals, whose personal service to the Crown far exceeds any
expected measure. And the badge of the award shall be a black dragon’s
head charged with the sigil of the Crown bestowing it.

So now does their Majesty call before them #name.
]

=== Sigillum Consortis/Regis/Regina (by the Consort)

/ Herald: #block[
The duties and responsibilities of a Consort are many. They must govern
and rule the land. They must be a patron of the arts and natural
philosophy. They must be the embodiment of gentle grace, courtesy,
virtue and love that their subjects expect.

Although They are supported by not only their Champion, but by all loyal
subjects whose service they may command, there are those of their
subjects without whom the Crown could not rule half so joyously, for
their constant attention to their needs makes light the day-to-day
details of ruling and their tireless devotion serves to ease the burden
of Royal responsibility.

Therefore was created the Sigillum Consortis, to recognise those
individuals, whose personal service to the Consort far exceeds any
expected measure. And the badge of the award shall be a white Edelweiss
charged with the sigil of the Consort bestowing it.

So now does their Majesty call before them #name.
]
]

#if sections.xii8 [
== 8. The Order of the Dragon’s Tear
<the-order-of-the-dragons-tear>
/ Herald: #block[
Whenever members of the Kingdom gather to fight or dance, revel or
conduct business, there are responsibilities which fall to the hosts so
that all may enjoy the event. It sometimes happens, however, that a
heavy burden falls upon a single individual or small group, so that a
great number of people might find special enjoyment.

Thus was created the Order of the Dragon’s Tear, for those worthy souls
who, as event stewards, overcome special difficulties or provide a
particularly enriching experience for the populace. And these gentles
shall be known by a teardrop-shaped pendant worn on a cord in the
colours of Drachenwald.

Now therefore do their Majesties call before them
#name.
]
]

#if sections.xii9 [
== 9. The Order of the Dragon’s Bowle
<the-order-of-the-dragons-bowle>
/ Herald: #block[
The occasion is always joyous when we gather together. However, the
occasion is doubly blessed when we can also enjoy a special display of
beauty and art. Therefore was created the Order of the Dragon’s Bowle,
to be given at the Crown’s discretion to those gentles whose care,
attention and artfulness in equipping themselves enhances the spirit of
the event to the delight of all.

And so do their Majesties call before them #name.
]
]

#if sections.xii10 [
== 10. The Order of the Dragon’s Jewel
<the-order-of-the-dragons-jewel>
/ Herald: #block[
We delight in the presence of children, because We know they represent
the future of all We hold all dear; but there are those young nobles who
contribute to our Kingdom and the Society not only beyond the measure of
their fellows, but also beyond the measure of their years.

And so do their Majesties call before them #name.
]
]

#if sections.xii11 [
== 11. The Order of the Dragon’s Pride
<the-order-of-the-dragons-pride>
/ Herald: #block[
The reward of artistic achievement and scientific knowledge is a joyful
duty for the Crown, as the product of such labour brings delight to all
who are touched by it; but when the skill resides in one of tender
years, the joy is especially great, since the Crown rewards not only the
work itself, but the promise of greater things to come.

Therefore was created the Order of the Dragon’s Pride, to reward
artistic or philosophic achievement in a young member of the people.

And so do their Majesties call before them #name.
]
]

#if sections.xii12 [
== 12. Popular Company of Sojourners
<popular-company-of-sojourners>
/ Herald: #block[
Our beloved realm was founded by travellers who came to this land from
distant shores and made it their home. We are proud that to this day,
travellers still come and abide in our land.

But alas, as travellers come, they also go, and often it is our sad task
to bid farewell to those whose path leads them away from Drachenwald. It
is especially sad when those travellers have served the Kingdom well and
become beloved of the people.

Thus was created the Popular Company of Sojourners, to recognise those
who leave Drachenwald the richer for their time here.

And so do their Majesties call before them #name.
]
]

#if sections.xii13 [
== 13. The Order of the Hospitallers of Albion
<the-order-of-the-hospitallers-of-albion>
/ Herald: #block[
There are times when the Crown of Drachenwald travels to distant lands
either to stand with other kingdoms on the field of battle, fighting
injustice and defending the weak, or for the pleasure to be gained from
foreign travels where the beauty of the Known World may be experienced
and enjoyed. During these travels, the Crown is sometimes aided and
supported by gentles of those foreign lands, whose sacrifice on behalf
of our Crown may be great indeed.

Therefore was created the Order of the Hospitallers of Albion, to reward
and thank those gentles or groups who, while not subjects of
Drachenwald, have shown unselfish service to our Kingdom and its Crown
during these travels.

And so do their Majesties call before them #name.
]
]

#if sections.xiii [
= Part XIII Other Ceremonies
<part-ii-other-ceremonies>
]

#if sections.xiii1 [
== 1. Creation of a Pursuivant or Herald
<creation-of-a-pursuivant-or-herald>
#emph[In theory any noble, singly or as a couple, can appoint their own
herald.]

/ Herald: #block[
Know that We #name \[and #name\], #name \[and #name\] of
#name, have need of a pursuivant / herald to carry
our messages in peace and war, to be our voice, and to teach the noble
arts of heraldry. Know also that hearing good report of our faithful
servant #name as a gentle(wo)man skilled in the
arts of honour we are minded to appoint them as our Pursuivant / Herald
\[Extraordinary\].

In witness thereof we call forth all and any members of the College of
Heralds here present and direct them to present
#name before Us!
]

#emph[The heralds come forward, escorting the candidate, and stand
aside.]

/ Herald: #block[
Do you #name, of your own free will, swear to
serve #name \[and #name\] as pursuivant /
herald?
]

/ Candidate: #block[
#response
]

=== If swearing:

/ Herald: #block[
You shall swear by the faith that you owe to the Lords / Barons /
Princes / Sovereigns whose arms you shall bear, that you shall truly
keep such things as are comprised in the articles following:
]

#emph[Following each of the articles, the candidate responds "I so
swear".]

=== If not swearing:

/ Herald: #block[
By the faith that you owe to the Lords / Barons / Princes /
Sovereigns whose arms you shall bear, you shall truly keep such things
as are comprised in the articles following:

First, you shall be true to our high and most excellent Lords /
Barons / Princes / Sovereigns that they are, and to them that make you
a herald. And if you should have any knowledge or hear any imagination
of treason, you shall discover it to them or to their noble council; and
counsel it in no manner.

You shall be serviceable to all gentle persons to do their commandments
to their worship of noble deeds; and to excuse their worship by your
good counsel, and ever ready to offer your service to them.

You shall be secret and keep the secrets of knights, squires, ladies,
gentlewomen, and all manner of gentle folk; a confessor of arms; and not
discover them in any wise except treason aforesaid.

If you be in any place where you hear debate or peril between two
gentles which you be privy to, if so be it that you be required by
prince, judge, or any other to bear witness, you shall not be without
license of both parties, and when you have leave, you shall not testify
for any good favour or awe, but say the truth to your knowledge.
]

=== If investing a Kingdom, Principality or Regional Herald

/ Herald: #block[
You shall pursue learning, and teach officers of arms under you, all
manner of things pertaining to nobility.

You shall forsake all places of dishonesty and hazard and dishonestly
going to common taverns and places of debates and all manner of vices,
and take to virtues as much as you are able.
]

=== If swearing
#emph[(Be aware of the potential religious sensitivities of this action. It may be omitted.)]

/ Herald: #block[
These articles you have sworn truly to keep with all your might and
power.
]

#emph[An attendant moves forward and gives the goblet of water to the
appointing noble who slowly pours a bit of water from the goblet over
the candidate’s head while speaking these words:]

=== If swearing:

/ Presiding noble: #block[
Then, by your oath, I do create you pursuivant / herald by the name of
#name. As you shall serve Us as pursuivant /
herald, We shall reward you with largesse.
]

=== If not swearing:

/ Presiding noble: #block[
I hereby create you pursuivant / herald by the name of
#name. As you shall serve Us as pursuivant /
herald, We shall reward you with largesse.
]

#emph[Sovereign/Baron gives the cup to the candidate.]

=== If creating a Pursuivant

/ Herald: #block[
Let the pursuivant be invested with his tabard of office, and let him
wear it athwart as befits his rank of pursuivant, and in no other way.
]

#emph[Attendents move forward and put a tabard on the candidate. The
tabard should be put on so that the arms of the tabard are on the
candidate’s chest and the front and back drape over the candidate’s
shoulders and arms.]

=== If creating a Herald

/ Herald: #block[
Let the herald be invested with his tabard of office and let him wear it
so that he may be known as a herald.
]

#emph[Attendants move forward and put a tabard over the head of the
candidate so that it is athwart. Then, in a separate and obvious motion,
the tabard is turned so that it is worn properly. If the candidate was
already wearing a tabard athwart then the attendants turn the tabard so
that it is worn properly.]

/ Presiding Noble: #block[
Arise, #name, and go forth.
]

#emph[The herald exhorts cheers from the populace.]

=== Acknowledgements

#emph[This is heavily based on a ceremony composed by Lothar von
Katzenellenbogen and subsequently adapted by Eiríkr Sigurðarson for use
within the Caidan College of Heralds.]
]

#if sections.xiv [
= Part XIV Oaths
<part-xiv-oaths>
Oaths are a very personal thing and the ceremonies below should be taken
as templates. Custom varied in period, as do preferences now, as to
whether an oath is to the person or the office, to successors or not,
what exactly is sworn to by the person giving the oath and whether it is
done publicly or privately. The Crown, heralds and oath-givers should be
flexible in how this aspect of fealty is handled.
]

#if sections.xiv1 [
== 1. Coronation Oath
<coronation-oath>
/ Seneschal: #block[
Will You love all that is true and fair, and fight all falsehoods, lies
and injustice, both with Your Royal powers and with justice?
]

/ Coronets: #block[
I will.
]

/ Seneschal: #block[
Will You be true to Your people, confirm to them their old rights and
privileges, and not take away from anyone what is rightfully theirs,
except after proper verdict of law?
]

/ Coronets: #block[
I will.
]

/ Seneschal: #block[
Will You protect the Realm to the best of Your ability, so that when the
time comes You will leave Your successors a strong Kingdom, as is their
due?
]

/ Coronets: #block[
I will.
]

#emph[Modelled after the coronation oath in the King Christopher law of
1440’s Scandinavia.]
]

#if sections.xiv2 [
== 2. Kingdom Officers’ Oath
<kingdom-officers-oath>
/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Officers: #block[
I will.
]

/ Herald: #block[
Will you give Them such obedience as is their due, obeying their
commands in such matters as are theirs to command?
]

/ Officers: #block[
I will.
]

/ Herald: #block[
Will you be a true officer of the Kingdom, discharging your duties to
the best of your ability?
]

/ Officers: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to support you with Our royal power and justice.

So say We #name, Rex/Regina.
]

/ Monarch: #block[
So say We #name, Rex/Regina.
]

#emph[Modelled after the oath of allegiance for populace in the King
Christopher law of 1440’s Scandinavia.]
]

#if sections.xiv3 [
== 3. Peers’ Oath
<peers-oath>
/ Herald: #block[
Will you hold #name and #name your
rightful Sovereigns, right until the end of their lawful reign, and
support their royal might and justice?
]

/ Peer: #block[
I will
]

/ Herald: #block[
Do you wish to give the Crown such counsel which is to the benefit of
Them and their Realm, and support Them in upholding the laws and
fulfilling their coronation oath?
]

/ Peer: #block[
I will.
]

/ Herald: #block[
And will you keep secret such matters as the Crown wants to keep in
confidence, and not divulge such secrets that could harm their Realm?
]

/ Peer: #block[
I will.
]

/ Monarch: #block[
And We in turn promise to grant you, the Peers of our Realm, and your
households, all the rights and privileges of old, and to protect you
with the Law of the Realm.

So say We #name, Rex/Regina
]

/ Monarch: #block[
So say We #name, Rex/Regina
]

#emph[Modelled after the oaths of allegiance for populace and for the
King’s Council in the King Christopher law of 1440’s Scandinavia.]
]

#if sections.xiv4 [
== 4. Oath of Fealty for Principalities and Baronies
<oath-of-fealty-for-principalities-and-baronies>
/ Herald: #block[
Let all present and to come know that I #name,
#name of #name, acknowledge to You
#name and #name, Sovereigns of
Drachenwald, that I hold and ought to hold as a fief the
#name of #name. For this I make
homage and fealty with hands and with mouth to You my Sovereigns, and I
swear that I will always be a faithful vassal to You in all things in
which a vassal is required to be faithful, and I will defend You and the
Kingdom and #name against all malefactors and
invaders, and I will give You power over all the castles and manors in
the #name, in peace and in war, whenever they shall
be lawfully claimed by You.

And if I do not observe to You each and all the things declared above,
and should come against these things, I wish that the aforesaid fief
should by that very fact be handed over to You and to the Kingdom of
Drachenwald.
]

/ Ruling Noble: #block[
So say I #name, #name.
]

#emph[Modelled after the oath of fealty of the Viscount of Carcassonne,
1110.]
]
